/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.parser;

import java.util.NoSuchElementException;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.parser.AbstractTestElementIterator;
import jp.vmi.selenium.selenese.parser.CommandIterator;
import jp.vmi.selenium.selenese.parser.ParserUtils;
import jp.vmi.selenium.selenese.parser.SeleneseTestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestCaseEntry;
import jp.vmi.selenium.selenese.parser.TestCaseIterator;
import jp.vmi.selenium.selenese.parser.TestElementIterator;
import jp.vmi.selenium.selenese.parser.TestElementIteratorFactory;
import jp.vmi.selenium.selenese.parser.TestSuiteEntry;
import jp.vmi.selenium.selenese.parser.TestSuiteIterator;

public class SeleneseTestSuiteIterator
extends AbstractTestElementIterator<TestSuiteEntry>
implements TestSuiteIterator {
    private TestElementIteratorFactory<TestCaseIterator, TestSuiteEntry> iterFactory;
    private boolean hasNext = true;

    SeleneseTestSuiteIterator(TestElementIterator<?> iter) throws InvalidSeleneseException {
        super(iter.getFilename());
        this.setName(ParserUtils.getNameFromFilename(iter.getFilename()));
        this.setId(iter.getFilename());
        this.iterFactory = iter instanceof SeleneseTestCaseIterator ? suiteEntry -> (SeleneseTestCaseIterator)iter : suiteEntry -> new SingleTestCaseIterator((CommandIterator)iter);
    }

    @Override
    public boolean isDummy() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public TestSuiteEntry next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        return new TestSuiteEntry(this.getId(), this.getName());
    }

    @Override
    public TestElementIteratorFactory<TestCaseIterator, TestSuiteEntry> getTestCaseIteratorFactory() {
        return this.iterFactory;
    }

    private static class SingleTestCaseIterator
    extends AbstractTestElementIterator<TestCaseEntry>
    implements TestCaseIterator {
        private final CommandIterator commandIterator;
        private boolean hasNext = true;

        public SingleTestCaseIterator(CommandIterator commandIterator) {
            super(commandIterator.getFilename());
            this.setName(commandIterator.getName());
            this.setId(commandIterator.getId());
            this.commandIterator = commandIterator;
        }

        @Override
        public boolean isDummy() {
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public TestCaseEntry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return new TestCaseEntry(false, this.commandIterator.getId(), this.commandIterator.getName());
        }

        @Override
        public TestElementIteratorFactory<CommandIterator, TestCaseEntry> getCommandIteratorFactory() {
            return testCaseEntry -> this.commandIterator;
        }
    }
}

