/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.result;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Selenese;

public abstract class Result
implements Comparable<Result> {
    private static final Pattern SKIP_RE = Pattern.compile("ByGuice|^com\\.google\\.inject\\.|^java\\.lang\\.reflect\\.|^sun\\.reflect\\.|^org\\.junit\\.|^org\\.eclipse\\.jdt\\.");
    private final String message;
    private List<Map.Entry<Selenese, Result>> childResults = null;

    public Result(String message) {
        this.message = message;
    }

    public Result(String prefix, String message) {
        this.message = prefix + ": " + message;
    }

    public Result(String prefix, Exception e) {
        this.message = this.generateExceptionMessage(prefix, e);
    }

    public Result(String prefix, String message, Exception e) {
        StringBuilder result = new StringBuilder(prefix).append(": ").append(message).append(" - ");
        this.message = this.generateExceptionMessage(result, e);
    }

    protected Result(Result childResult) {
        this.message = childResult.message;
    }

    protected Result newUpdatedResult(Result targetResult) {
        try {
            Constructor<?> c = targetResult.getClass().getConstructor(Result.class);
            Result newResult = (Result)c.newInstance(targetResult);
            newResult.childResults = this.childResults;
            return newResult;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Cannot construct " + this.getClass() + " with Result", e);
        }
    }

    protected String generateExceptionMessage(String prefix, Exception e) {
        return this.generateExceptionMessage(new StringBuilder(prefix).append(": "), e);
    }

    protected String generateExceptionMessage(StringBuilder result, Exception e) {
        String msg = e.getMessage();
        if (msg != null) {
            result.append(e.getClass().getSimpleName()).append(" - ").append(msg);
        } else {
            result.append(e.getClass().getName());
        }
        result.append(" (");
        boolean sep = false;
        for (StackTraceElement stackTrace : e.getStackTrace()) {
            String className = stackTrace.getClassName();
            if (className == null || SKIP_RE.matcher(className).find()) continue;
            if (sep) {
                result.append(" / ");
            }
            result.append(className.replaceFirst("^.*\\.", "")).append('.').append(stackTrace.getMethodName());
            String fileName = stackTrace.getFileName();
            if (fileName != null) {
                result.append('(').append(fileName);
                int lineNumber = stackTrace.getLineNumber();
                if (lineNumber >= 0) {
                    result.append(':').append(lineNumber);
                }
                result.append(')');
            }
            sep = true;
        }
        result.append(")");
        return result.toString();
    }

    public abstract Level getLevel();

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.getLevel() == Level.SUCCESS;
    }

    public boolean isAborted() {
        return this.getLevel().value >= Level.FAILURE.value;
    }

    public boolean isFailed() {
        return this.getLevel().value >= Level.WARNING.value;
    }

    @Deprecated
    public Result update(Result newResult) {
        return newResult.getLevel().value > this.getLevel().value ? newResult : this;
    }

    public Result updateWithChildResult(Selenese childSource, Result childResult) {
        Result newResult = childResult.getLevel().value > this.getLevel().value ? this.newUpdatedResult(childResult) : this;
        if (newResult.childResults == null) {
            newResult.childResults = new ArrayList<Map.Entry<Selenese, Result>>();
        }
        newResult.childResults.add(new AbstractMap.SimpleEntry<Selenese, Result>(childSource, childResult));
        return newResult;
    }

    public List<Map.Entry<Selenese, Result>> getChildResults() {
        if (this.childResults == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.childResults);
    }

    private List<Map.Entry<Selenese, Result>> collectChildResults(Selenese.Type type, List<Map.Entry<Selenese, Result>> results) {
        if (this.childResults != null) {
            for (Map.Entry<Selenese, Result> entry : this.childResults) {
                if (entry.getKey().getType() == type) {
                    results.add(entry);
                    continue;
                }
                entry.getValue().collectChildResults(type, results);
            }
        }
        return results;
    }

    public List<Map.Entry<Selenese, Result>> collectChildResults(Selenese.Type type) {
        return this.collectChildResults(type, new ArrayList<Map.Entry<Selenese, Result>>());
    }

    @Override
    public int compareTo(Result result) {
        return this.getLevel().compareTo(result.getLevel());
    }

    public String toString() {
        return "[" + this.message + "]";
    }

    public static enum Level {
        UNEXECUTED(-1, 0, 5),
        SUCCESS(0, 0, 0),
        WARNING(1, 0, 2),
        FAILURE(2, 3, 3),
        ERROR(3, 3, 4),
        MAX_TIME_EXCEEDED(4, 3, 6),
        FATAL(5, 70, 70),
        USAGE(6, 64, 64);

        public final int value;
        public final int exitCode;
        public final int strictExitCode;

        private Level(int value, int exitCode, int strictExitCode) {
            this.value = value;
            this.exitCode = exitCode;
            this.strictExitCode = strictExitCode;
        }
    }
}

