/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jp.vmi.selenium.selenese.config.IConfig;
import jp.vmi.selenium.selenese.utils.LangUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverOptions {
    private static final Logger log = LoggerFactory.getLogger(DriverOptions.class);
    private static final Pattern DEFINE_RE = Pattern.compile("(?<name>[^:+=]+)(?::(?<type>\\w+))?(?<add>\\+)?=(?<value>.*)");
    private final IdentityHashMap<DriverOption, Object> map = Maps.newIdentityHashMap();
    private final DesiredCapabilities caps = new DesiredCapabilities();
    private String[] cliArgs = ArrayUtils.EMPTY_STRING_ARRAY;
    private List<File> chromeExtensions = new ArrayList<File>();
    private final HashMap<String, String> envVars = Maps.newHashMap();
    private static final Comparator<Map.Entry<String, ?>> mapEntryComparator = new Comparator<Map.Entry<String, ?>>(){

        @Override
        public int compare(Map.Entry<String, ?> e1, Map.Entry<String, ?> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    };

    public DriverOptions() {
    }

    public DriverOptions(IConfig config) {
        for (DriverOption opt : DriverOption.values()) {
            this.set(opt, config.get(opt.optionName()));
        }
    }

    public DriverOptions(DriverOptions other) {
        this.map.putAll(other.map);
        this.caps.merge((Capabilities)other.caps);
        this.cliArgs = other.cliArgs;
        this.chromeExtensions = other.chromeExtensions;
        this.envVars.putAll(other.envVars);
    }

    public String get(DriverOption opt) {
        switch (opt) {
            case DEFINE: {
                throw new IllegalArgumentException("Need to use DriverOptions#getCapabilities() instead of get(DriverOption.DEFINE).");
            }
            case CLI_ARGS: {
                throw new IllegalArgumentException("Need to use DriverOptions#getExtraOptions() instead of get(DriverOption.CLI_ARGS).");
            }
            case CHROME_EXTENSION: {
                throw new IllegalArgumentException("Need to use DriverOptions#getExtraOptions() instead of get(DriverOption.CHROME_EXTENSION).");
            }
        }
        if (opt.valueType != String.class) {
            throw new IllegalArgumentException("The option value of " + (Object)((Object)opt) + " is not String.");
        }
        return (String)this.map.get((Object)opt);
    }

    public boolean getBoolean(DriverOption opt) {
        if (opt.valueType != Boolean.class) {
            throw new IllegalArgumentException("The option value of " + (Object)((Object)opt) + " is not boolean.");
        }
        Object value = this.map.get((Object)opt);
        return value != null ? (Boolean)value : false;
    }

    public boolean has(DriverOption opt) {
        switch (opt) {
            case DEFINE: {
                return !this.caps.asMap().isEmpty();
            }
            case CLI_ARGS: {
                return this.cliArgs.length != 0;
            }
            case CHROME_EXTENSION: {
                return !this.chromeExtensions.isEmpty();
            }
            case ALERTS_POLICY: {
                return this.caps.getCapability("unexpectedAlertBehaviour") != null;
            }
        }
        return this.map.containsKey((Object)opt);
    }

    public DriverOptions set(DriverOption opt, String ... values) {
        switch (opt) {
            case DEFINE: 
            case CLI_ARGS: 
            case CHROME_EXTENSION: {
                return this.set(opt, (Object)values);
            }
        }
        if (values.length != 1) {
            throw new IllegalArgumentException("Need to pass only a single value for " + (Object)((Object)opt));
        }
        return this.set(opt, (Object)values[0]);
    }

    private static UnexpectedAlertBehaviour parseUnexpectedAlertBehaviour(Object value) {
        if (value == null || value instanceof UnexpectedAlertBehaviour) {
            return (UnexpectedAlertBehaviour)value;
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(UnexpectedAlertBehaviour.class, ((String)value).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(String.format("The value of %s is \"%s\". It must be one of the following: accept, dismiss, accept_and_notify, dismiss_and_notify, ignore", DriverOption.ALERTS_POLICY.optionName(), value));
    }

    private static boolean isOptionValueTypeValid(DriverOption opt, Object value) {
        return opt.valueType.isAssignableFrom(value.getClass());
    }

    public DriverOptions set(DriverOption opt, Object value) {
        switch (opt) {
            case DEFINE: {
                if (value == null) {
                    return this;
                }
                if (!DriverOptions.isOptionValueTypeValid(opt, value)) break;
                this.addDefinitions((String[])value);
                return this;
            }
            case CLI_ARGS: {
                if (value == null) {
                    return this;
                }
                if (!DriverOptions.isOptionValueTypeValid(opt, value)) break;
                this.cliArgs = (String[])ArrayUtils.addAll((Object[])this.cliArgs, (Object[])((String[])value));
                return this;
            }
            case CHROME_EXTENSION: {
                if (value == null) {
                    return this;
                }
                if (!DriverOptions.isOptionValueTypeValid(opt, value)) break;
                for (String ext : (String[])value) {
                    this.chromeExtensions.add(new File(ext));
                }
                return this;
            }
            case ALERTS_POLICY: {
                UnexpectedAlertBehaviour uab = DriverOptions.parseUnexpectedAlertBehaviour(value);
                this.caps.setCapability("unexpectedAlertBehaviour", (Object)uab);
                return this;
            }
            default: {
                if (value == null) {
                    this.map.remove((Object)opt);
                } else {
                    this.map.put(opt, value);
                }
                return this;
            }
        }
        throw new IllegalArgumentException(String.format("The type of the option value of %s must be %s, but it is %s (value = %s)", new Object[]{opt, opt.valueType.getSimpleName(), value.getClass().getSimpleName(), value}));
    }

    private static Object getTypedValue(String name, String type, String value, Consumer<String> errorHandler) {
        switch (name) {
            case "unexpectedAlertBehaviour": {
                return DriverOptions.parseUnexpectedAlertBehaviour(value);
            }
        }
        if (type == null) {
            return value;
        }
        switch (type) {
            case "str": {
                return value;
            }
            case "int": {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    errorHandler.accept("\"" + value + "\" is not integer");
                    return null;
                }
            }
            case "bool": {
                return Boolean.valueOf(value);
            }
        }
        errorHandler.accept("unrecognized type: " + type);
        return null;
    }

    private static String getTypeName(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz == String.class) {
            return "str";
        }
        if (clazz == Boolean.class) {
            return "bool";
        }
        return "(unknown)";
    }

    private void appendCapValue(String name, Object value, Consumer<String> errorHandler) {
        Object[] newValue;
        Object prevValue = this.caps.getCapability(name);
        try {
            if (prevValue == null || prevValue.getClass().isArray()) {
                newValue = ArrayUtils.add((Object[])((Object[])prevValue), (Object)value);
            } else {
                newValue = (Object[])Array.newInstance(prevValue.getClass(), 2);
                newValue[0] = prevValue;
                newValue[1] = value;
            }
        }
        catch (ArrayStoreException e) {
            errorHandler.accept(String.format("the expected type is %s, but the actual type is %s", DriverOptions.getTypeName(prevValue), DriverOptions.getTypeName(value)));
            return;
        }
        this.caps.setCapability(name, (Object)newValue);
    }

    public DriverOptions addDefinitions(String ... defs) {
        if (defs == null) {
            return this;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (String def : defs) {
            Matcher matcher = DEFINE_RE.matcher(def);
            if (!matcher.matches()) {
                errors.add("[" + def + "] => invalid format (neither key[:type]=value nor key[:type]+=value)");
                continue;
            }
            String name = matcher.group("name");
            Object value = DriverOptions.getTypedValue(name, matcher.group("type"), matcher.group("value"), msg -> errors.add("[" + def + "] => " + msg));
            if (value == null) continue;
            String add = matcher.group("add");
            if (add == null) {
                this.caps.setCapability(name, value);
                continue;
            }
            this.appendCapValue(name, value, msg -> errors.add("[" + def + "] => " + msg));
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.stream().collect(Collectors.joining(" / ")));
        }
        return this;
    }

    public String[] getCliArgs() {
        return this.cliArgs;
    }

    public List<File> getChromeExtensions() {
        return this.chromeExtensions;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    private void eachCapabilities(Map<String, Object> capsMap, BiConsumer<String, Object> consumer) {
        ArrayList<Map.Entry<String, Object>> capsList = new ArrayList<Map.Entry<String, Object>>(capsMap.entrySet());
        Collections.sort(capsList, mapEntryComparator);
        for (Map.Entry entry : capsList) {
            consumer.accept((String)entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        Map capsMap;
        StringBuilder result = new StringBuilder("[");
        String sep = "";
        if (!this.map.isEmpty()) {
            block5: for (DriverOption driverOption : DriverOption.values()) {
                switch (driverOption) {
                    case DEFINE: 
                    case ALERTS_POLICY: {
                        continue block5;
                    }
                    case CLI_ARGS: {
                        if (this.cliArgs.length == 0) continue block5;
                        result.append(driverOption.optionName()).append('=');
                        for (String extraOption : this.cliArgs) {
                            result.append(extraOption).append(',');
                        }
                        result.setCharAt(result.length() - 1, '|');
                        continue block5;
                    }
                    case CHROME_EXTENSION: {
                        if (this.chromeExtensions.isEmpty()) continue block5;
                        result.append(driverOption.optionName()).append('=');
                        for (File extraOption : this.chromeExtensions) {
                            result.append(extraOption.toString()).append(',');
                        }
                        result.setCharAt(result.length() - 1, '|');
                        continue block5;
                    }
                    default: {
                        if (!this.map.containsKey((Object)driverOption)) continue block5;
                        result.append(driverOption.optionName()).append('=').append(this.map.get((Object)driverOption)).append('|');
                    }
                }
            }
            result.deleteCharAt(result.length() - 1);
            sep = "|";
        }
        if (!(capsMap = this.caps.asMap()).isEmpty()) {
            this.eachCapabilities(capsMap, (key, value) -> {
                if (value instanceof Object[]) {
                    value = LangUtils.join((CharSequence)", ", Arrays.stream((Object[])value));
                }
                result.append("  ").append((String)key).append('=').append(value).append("\n");
            });
            result.append(']');
            sep = "|";
        }
        if (!this.envVars.isEmpty()) {
            result.append(sep).append("ENV_VARS=[\n");
            ArrayList<Map.Entry<String, String>> envVarsList = new ArrayList<Map.Entry<String, String>>(this.envVars.entrySet());
            Collections.sort(envVarsList, mapEntryComparator);
            for (Map.Entry entry : envVarsList) {
                result.append("  ").append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("\n");
            }
            result.append(']');
        }
        result.append(']');
        return result.toString();
    }

    public DesiredCapabilities getCapabilities() {
        Map capsMap = this.caps.asMap();
        if (capsMap.isEmpty()) {
            log.info("No capabilities.");
        } else {
            log.info("Capabilities:");
            this.eachCapabilities(capsMap, (key, value) -> log.info("- {}: {}", key, value));
        }
        return this.caps;
    }

    public static enum DriverOption {
        PROFILE,
        PROFILE_DIR,
        PROXY_TYPE,
        PROXY,
        PROXY_USER,
        PROXY_PASSWORD,
        NO_PROXY,
        FIREFOX,
        GECKODRIVER,
        CHROMEDRIVER,
        IEDRIVER,
        EDGEDRIVER,
        PHANTOMJS,
        REMOTE_PLATFORM,
        REMOTE_BROWSER,
        REMOTE_VERSION,
        REMOTE_URL,
        WIDTH,
        ALERTS_POLICY(UnexpectedAlertBehaviour.class),
        HEIGHT,
        DEFINE(String[].class),
        CLI_ARGS(String[].class),
        CHROME_EXTENSION(String[].class),
        CHROME_EXPERIMENTAL_OPTIONS,
        HEADLESS(Boolean.class);

        private final Class<?> valueType;

        private DriverOption(Class<?> valueType) {
            this.valueType = valueType;
        }

        private DriverOption() {
            this(String.class);
        }

        public String optionName() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
        }
    }
}

