/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Locale;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    protected static final int DEFAULT_WIDTH = 1024;
    protected static final int DEFAULT_HEIGHT = 768;

    public String getBrowserName() {
        String name = this.getClass().getSimpleName();
        if (Strings.isNullOrEmpty((String)name)) {
            return "";
        }
        if (name.endsWith("WebDriverFactory")) {
            return name.substring(0, name.length() - "WebDriverFactory".length()).toLowerCase();
        }
        if (name.endsWith("DriverFactory")) {
            return name.substring(0, name.length() - "DriverFactory".length()).toLowerCase();
        }
        return name.toLowerCase();
    }

    public boolean isProxySupported() {
        return true;
    }

    public static <B extends DriverService.Builder<?, B>> B setupBuilder(B builder, DriverOptions driverOptions, DriverOptions.DriverOption driverKey) {
        builder = builder.usingAnyFreePort().withEnvironment(driverOptions.getEnvVars());
        if (driverKey != null && driverOptions.has(driverKey)) {
            File executable = new File(PathUtils.normalize(driverOptions.get(driverKey)));
            if (!executable.canExecute()) {
                throw new IllegalArgumentException("Missing driver executable: " + executable);
            }
            builder = builder.usingDriverExecutable(executable);
        }
        return builder;
    }

    public static Proxy newProxy(DriverOptions driverOptions) {
        Proxy.ProxyType proxyType;
        if (!driverOptions.has(DriverOptions.DriverOption.PROXY_TYPE) && !driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            return null;
        }
        String proxyTypeStr = driverOptions.get(DriverOptions.DriverOption.PROXY_TYPE);
        if (proxyTypeStr == null) {
            proxyTypeStr = "manual";
        }
        try {
            proxyType = Proxy.ProxyType.valueOf((String)proxyTypeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unsupported proxy type: {}", (Object)proxyTypeStr);
            return null;
        }
        Proxy proxy = new Proxy();
        proxy.setProxyType(proxyType);
        String proxyStr = driverOptions.get(DriverOptions.DriverOption.PROXY);
        if (proxyStr != null) {
            switch (proxyType) {
                case MANUAL: {
                    proxy.setHttpProxy(proxyStr).setSslProxy(proxyStr).setFtpProxy(proxyStr);
                    break;
                }
                case PAC: {
                    proxy.setProxyAutoconfigUrl(proxyStr);
                    break;
                }
                default: {
                    log.warn("--proxy is not supported if proxy type is {}.", (Object)proxyTypeStr);
                }
            }
        }
        if (driverOptions.has(DriverOptions.DriverOption.NO_PROXY)) {
            proxy.setNoProxy(driverOptions.get(DriverOptions.DriverOption.NO_PROXY));
        }
        return proxy;
    }

    protected DesiredCapabilities setupProxy(DesiredCapabilities caps, DriverOptions driverOptions) {
        Proxy proxy = WebDriverFactory.newProxy(driverOptions);
        if (proxy != null) {
            if (this.isProxySupported()) {
                caps.setCapability("proxy", (Object)proxy);
            } else {
                log.warn("No support proxy with {}. Please set proxy to browser configuration in advance.", (Object)this.getClass().getSimpleName().replaceFirst("Factory$", ""));
            }
        }
        return caps;
    }

    public abstract WebDriver newInstance(DriverOptions var1);

    protected void setInitialWindowSize(WebDriver driver, DriverOptions driverOptions) {
        Dimension size;
        if (driverOptions.has(DriverOptions.DriverOption.WIDTH) || driverOptions.has(DriverOptions.DriverOption.HEIGHT)) {
            int width = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.WIDTH), (int)1024);
            int height = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.HEIGHT), (int)768);
            size = new Dimension(width, height);
        } else {
            size = this.getDefaultWindowSize(driver);
            if (size == null) {
                log.info("Initial window size: system default");
                return;
            }
        }
        driver.manage().window().setSize(size);
        log.info("Initial window size: {}x{}", (Object)size.width, (Object)size.height);
    }

    protected Dimension getDefaultWindowSize(WebDriver driver) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        return this == obj || this.getClass() == obj.getClass();
    }
}

