/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.rollup;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jp.vmi.script.JSList;
import jp.vmi.script.JSMap;
import jp.vmi.selenium.rollup.IRollupRule;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import org.apache.commons.lang3.StringUtils;

public class RollupRule
implements IRollupRule {
    private final ScriptEngine engine;
    private final Map<?, ?> rule;

    RollupRule(ScriptEngine engine, Map<?, ?> rule) {
        this.engine = engine;
        this.rule = rule;
    }

    @Override
    public String getName() {
        return (String)this.rule.get("name");
    }

    @Override
    public CommandList getExpandedCommands(Context context, Map<String, String> rollupArgs) {
        List commands;
        if (this.rule.containsKey("expandedCommands")) {
            commands = JSList.toList(this.engine, this.rule.get("expandedCommands"));
        } else {
            Bindings bindings = this.engine.createBindings();
            if (this.rule instanceof JSMap) {
                bindings.put("rule", ((JSMap)this.rule).unwrap());
            } else {
                bindings.put("rule", (Object)this.rule);
            }
            String args = new Gson().toJson(rollupArgs);
            try {
                commands = JSList.toList(this.engine, this.engine.eval("rule.getExpandedCommands(" + args + ")", bindings));
            }
            catch (ScriptException e) {
                throw new SeleneseRunnerRuntimeException(e);
            }
        }
        ICommandFactory factory = context.getCommandFactory();
        CommandList commandList = Binder.newCommandList();
        int index = 0;
        for (Object o : commands) {
            Map c = JSMap.toMap(this.engine, o);
            String name = (String)c.get("command");
            String target = StringUtils.defaultString((String)((String)c.get("target")));
            String value = StringUtils.defaultString((String)((String)c.get("value")));
            ICommand command = factory.newCommand(++index, name, target, value);
            commandList.add(command);
        }
        return commandList;
    }
}

