/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.rollup;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jp.vmi.selenium.rollup.IRollupRule;
import jp.vmi.selenium.rollup.RollupManager;
import jp.vmi.selenium.rollup.RollupRule;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import org.apache.commons.lang3.StringUtils;

public class RollupRules {
    final ScriptEngine engine;
    final EngineType engineType;
    private final Map<String, RollupRule> rollupRules = new HashMap<String, RollupRule>();

    public RollupRules() {
        this.engine = new ScriptEngineManager().getEngineByExtension("js");
        if (this.engine == null) {
            throw new SeleneseRunnerRuntimeException("Script engine not found for js");
        }
        String engineName = this.engine.getFactory().getEngineName();
        EngineType engineType = null;
        for (EngineType et : EngineType.values()) {
            if (!et.matches(engineName)) continue;
            engineType = et;
            break;
        }
        if (engineType == null) {
            throw new SeleneseRunnerRuntimeException("Unknown script engine: " + engineName);
        }
        this.engineType = engineType;
    }

    public void load(final InputStream is) {
        RollupManager.rollupRulesContext(this, new Runnable(){

            @Override
            public void run() {
                try {
                    String packageName = RollupManager.class.getPackage().getName();
                    if (RollupRules.this.engineType == EngineType.NASHORN) {
                        RollupRules.this.engine.eval("load('nashorn:mozilla_compat.js');");
                    }
                    RollupRules.this.engine.eval("importPackage(Packages." + packageName + ");");
                    try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        RollupRules.this.engine.eval(r);
                    }
                    catch (IOException iOException) {}
                }
                catch (ScriptException e) {
                    throw new SeleneseRunnerRuntimeException(e);
                }
            }
        });
    }

    public void load(String filename) {
        try {
            this.load(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new SeleneseRunnerRuntimeException(e);
        }
    }

    public void addRule(Map<?, ?> rule) {
        this.rollupRules.put((String)rule.get("name"), new RollupRule(this.engine, rule));
    }

    public IRollupRule get(String name) {
        return this.rollupRules.get(name);
    }

    private static enum EngineType {
        RHINO("Rhino"),
        NASHORN("Nashorn");

        public final String engineName;

        private EngineType(String engineName) {
            this.engineName = engineName;
        }

        public boolean matches(String name) {
            return StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)this.engineName);
        }
    }
}

