/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.Timer;
import java.util.TimerTask;
import jp.vmi.selenium.selenese.MaxTimeTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxTimeActiveTimer
extends TimerTask
implements MaxTimeTimer,
Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MaxTimeActiveTimer.class);
    private final long startTime;
    private final long maxTime;
    private final Thread target;
    private final Timer timer = new Timer(this.getClass().getSimpleName());
    private final Thread.UncaughtExceptionHandler originalUncaughtExceptionHandler;

    MaxTimeActiveTimer(long maxTime) {
        this.target = Thread.currentThread();
        this.startTime = System.currentTimeMillis();
        this.maxTime = maxTime;
        this.originalUncaughtExceptionHandler = this.target.getUncaughtExceptionHandler();
    }

    public static boolean isInterruptedByMaxTimeTimer(Thread thread) {
        return thread.getUncaughtExceptionHandler() instanceof MaxTimeActiveTimer && ((MaxTimeActiveTimer)thread.getUncaughtExceptionHandler()).isTarget(thread);
    }

    private boolean isTarget(Thread thread) {
        return this.target.equals(thread);
    }

    @Override
    public void start() {
        long elapsed = System.currentTimeMillis() - this.startTime;
        long delay = this.maxTime - elapsed;
        if (delay < 0L) {
            log.warn("Maximum execution time has already been exceeded.");
            delay = 0L;
        }
        this.timer.schedule((TimerTask)this, delay);
    }

    @Override
    public void stop() {
        this.timer.cancel();
        this.timer.purge();
        this.target.setUncaughtExceptionHandler(this.originalUncaughtExceptionHandler);
    }

    @Override
    public void run() {
        log.error(String.format("Maximum execution time of %d seconds exceeded.", this.maxTime / 1000L));
        this.target.setUncaughtExceptionHandler(this);
        this.target.interrupt();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.target.getThreadGroup().uncaughtException(t, e);
    }
}

