/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.ArrayDeque;
import java.util.Deque;
import jp.vmi.html.result.IHtmlResultTestCase;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.EndLoop;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.command.StartLoop;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.inject.ExecuteTestCase;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.LogRecorder;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;

public class TestCase
implements Selenese,
ITestCase,
IHtmlResultTestCase {
    private String filename = null;
    private String baseName = null;
    private String name = null;
    private String baseURL = null;
    private StartLoop currentStartLoop = StartLoop.NO_START_LOOP;
    private final Deque<StartLoop> loopCommandStack = new ArrayDeque<StartLoop>();
    private final CommandList commandList = Binder.newCommandList();
    private final CommandResultList cresultList = new CommandResultList();
    private final StopWatch stopWatch = new StopWatch();
    private LogRecorder logRecorder = null;

    public TestCase initialize(String filename, String name, String baseURL) {
        String baseName;
        String string = baseName = (filename = PathUtils.normalize(filename)) != null ? FilenameUtils.getBaseName((String)filename) : name;
        if (name == null) {
            name = baseName;
        }
        this.filename = filename;
        this.baseName = baseName;
        this.name = name;
        this.baseURL = baseURL.replaceFirst("/+$", "");
        return this;
    }

    @Override
    public Selenese.Type getType() {
        return Selenese.Type.TEST_CASE;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public CommandList getCommandList() {
        return this.commandList;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    @Override
    public void setLogRecorder(LogRecorder logRecorder) {
        if (this.logRecorder != null) {
            throw new SeleneseRunnerRuntimeException("The log recorder of " + this + " is already set.");
        }
        this.logRecorder = logRecorder;
    }

    @Override
    public LogRecorder getLogRecorder() {
        return this.logRecorder;
    }

    @Override
    public Result getResult() {
        return this.cresultList.getResult();
    }

    @Override
    public CommandResultList getResultList() {
        return this.cresultList;
    }

    public void addCommand(ICommand command) {
        command.setStartLoop(this.currentStartLoop);
        if (command instanceof StartLoop) {
            this.loopCommandStack.push(this.currentStartLoop);
            this.currentStartLoop = (StartLoop)((Object)command);
        } else if (command instanceof EndLoop) {
            this.currentStartLoop.setEndLoop((EndLoop)((Object)command));
            this.currentStartLoop = this.loopCommandStack.pop();
        }
        this.commandList.add(command);
    }

    public void addCommand(ICommandFactory commandFactory, String name, String ... args) {
        int i = this.commandList.size() + 1;
        ICommand command = commandFactory.newCommand(i, name, args);
        this.addCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExecuteTestCase
    public Result execute(Selenese parent, Context context) {
        if (this.commandList.isEmpty()) {
            return this.cresultList.setResult(Success.SUCCESS);
        }
        if (parent instanceof TestCase) {
            try {
                context.setCurrentTestCase(this);
                Result result = this.commandList.execute(context, ((TestCase)parent).getResultList());
                return result;
            }
            finally {
                context.setCurrentTestCase((TestCase)parent);
            }
        }
        context.setCurrentTestCase(this);
        context.resetState();
        this.cresultList.setEndTime(System.currentTimeMillis());
        return this.commandList.execute(context, this.cresultList);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TestCase[").append(this.name).append("]");
        if (this.filename != null) {
            s.append(" (").append(this.filename).append(")");
        }
        return s.toString();
    }
}

