/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.Arrays;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assertion
extends AbstractCommand {
    private static final Logger log = LoggerFactory.getLogger(Assertion.class);
    private static final int RETRY_INTERVAL = 100;
    private final Type type;
    private final ISubCommand<?> getterSubCommand;
    private final boolean isBoolean;
    private final boolean isInverse;

    private static ArgumentType[] getArgumentTypesOfThisCommand(ArgumentType[] argTypes, boolean isBoolean) {
        return isBoolean ? argTypes : (ArgumentType[])ArrayUtils.add((Object[])argTypes, (Object)((Object)ArgumentType.VALUE));
    }

    Assertion(int index, String name, String[] args, String assertion, ISubCommand<?> getterSubCommand, boolean isBoolean, boolean isInverse) {
        super(index, name, args, Assertion.getArgumentTypesOfThisCommand(getterSubCommand.getArgumentTypes(), isBoolean));
        this.type = Type.of(assertion);
        this.getterSubCommand = getterSubCommand;
        this.isBoolean = isBoolean;
        this.isInverse = isInverse;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String expected;
        String[] getterArgs;
        if (this.isBoolean) {
            getterArgs = curArgs;
            expected = null;
        } else {
            int newLen = this.getterSubCommand.getArgumentTypes().length;
            getterArgs = Arrays.copyOf(curArgs, newLen);
            expected = curArgs[newLen];
        }
        boolean found = true;
        String message = null;
        int timeout = context.getTimeout();
        long breakAfter = System.currentTimeMillis() + (long)timeout;
        while (true) {
            found = true;
            if (this.isBoolean) {
                try {
                    boolean result = (Boolean)this.getterSubCommand.execute(context, getterArgs);
                    if (result ^ this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (Result: [%s] / Expected: [%s])", result, !result);
                }
                catch (NotFoundException | StaleElementReferenceException e) {
                    if (this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (%s)", e.getMessage());
                    found = false;
                }
            } else {
                try {
                    String resultString = SeleniumUtils.convertToString(this.getterSubCommand.execute(context, getterArgs));
                    if (SeleniumUtils.patternMatches(expected, resultString) ^ this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (Result: [%s] / %sExpected: [%s])", StringEscapeUtils.escapeJava((String)resultString), this.isInverse ? "Not " : "", StringEscapeUtils.escapeJava((String)expected));
                }
                catch (NotFoundException | StaleElementReferenceException e) {
                    if (this.isInverse) {
                        return Success.SUCCESS;
                    }
                    message = String.format("Assertion failed (%s)", e.getMessage());
                    found = false;
                }
            }
            if (this.type != Type.WAIT_FOR || System.currentTimeMillis() > breakAfter) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage());
                break;
            }
        }
        switch (this.type) {
            case ASSERT: {
                return new Failure(message);
            }
            case VERIFY: {
                return found ? new Warning(message) : new Failure(message);
            }
        }
        return new Warning(String.format("Timed out after %dms (%s)", timeout, message));
    }

    private static enum Type {
        ASSERT("assert"),
        VERIFY("verify"),
        WAIT_FOR("waitFor");

        private String assertion;

        private Type(String assertion) {
            this.assertion = assertion;
        }

        public static Type of(String assertion) {
            for (Type type : Type.values()) {
                if (!type.assertion.equals(assertion)) continue;
                return type;
            }
            return null;
        }
    }
}

