/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Click
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;

    Click(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String locator = curArgs[0];
        WebDriver driver = context.getWrappedDriver();
        WebElement element = context.getElementFinder().findElement(driver, locator);
        context.getJSLibrary().replaceAlertMethod(driver, element);
        try {
            element.click();
            return Success.SUCCESS;
        }
        catch (ElementNotInteractableException e) {
            context.executeScript("arguments[0].click()", element);
            return new Success("Success (the element is not visible)");
        }
    }
}

