/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.AddCollection;
import jp.vmi.selenium.selenese.command.AddLocationStrategy;
import jp.vmi.selenium.selenese.command.AddSelection;
import jp.vmi.selenium.selenese.command.AddToCollection;
import jp.vmi.selenium.selenese.command.AllowNativeXpath;
import jp.vmi.selenium.selenese.command.AltKeyDown;
import jp.vmi.selenium.selenese.command.AltKeyUp;
import jp.vmi.selenium.selenese.command.AnswerOnNextPrompt;
import jp.vmi.selenium.selenese.command.Assertion;
import jp.vmi.selenium.selenese.command.AssignId;
import jp.vmi.selenium.selenese.command.AttachFile;
import jp.vmi.selenium.selenese.command.BuiltInCommand;
import jp.vmi.selenium.selenese.command.CaptureEntirePageScreenshot;
import jp.vmi.selenium.selenese.command.Check;
import jp.vmi.selenium.selenese.command.ChooseCancelOnNextConfirmation;
import jp.vmi.selenium.selenese.command.ChooseOkOnNextConfirmation;
import jp.vmi.selenium.selenese.command.Click;
import jp.vmi.selenium.selenese.command.ClickAt;
import jp.vmi.selenium.selenese.command.Close;
import jp.vmi.selenium.selenese.command.Comment;
import jp.vmi.selenium.selenese.command.ControlKeyDown;
import jp.vmi.selenium.selenese.command.ControlKeyUp;
import jp.vmi.selenium.selenese.command.CreateCookie;
import jp.vmi.selenium.selenese.command.DeleteAllVisibleCookies;
import jp.vmi.selenium.selenese.command.DeleteCookie;
import jp.vmi.selenium.selenese.command.DeselectPopUp;
import jp.vmi.selenium.selenese.command.DoubleClick;
import jp.vmi.selenium.selenese.command.DragAndDrop;
import jp.vmi.selenium.selenese.command.DragAndDropToObject;
import jp.vmi.selenium.selenese.command.Echo;
import jp.vmi.selenium.selenese.command.EditContent;
import jp.vmi.selenium.selenese.command.EndFor;
import jp.vmi.selenium.selenese.command.EndWhile;
import jp.vmi.selenium.selenese.command.FireEvent;
import jp.vmi.selenium.selenese.command.Focus;
import jp.vmi.selenium.selenese.command.GoBack;
import jp.vmi.selenium.selenese.command.GotoIf;
import jp.vmi.selenium.selenese.command.Gotolabel;
import jp.vmi.selenium.selenese.command.Highlight;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.command.Include;
import jp.vmi.selenium.selenese.command.KeyDown;
import jp.vmi.selenium.selenese.command.KeyPress;
import jp.vmi.selenium.selenese.command.KeyUp;
import jp.vmi.selenium.selenese.command.Label;
import jp.vmi.selenium.selenese.command.MetaKeyDown;
import jp.vmi.selenium.selenese.command.MetaKeyUp;
import jp.vmi.selenium.selenese.command.Open;
import jp.vmi.selenium.selenese.command.OpenWindow;
import jp.vmi.selenium.selenese.command.Pause;
import jp.vmi.selenium.selenese.command.Refresh;
import jp.vmi.selenium.selenese.command.RemoveAllSelections;
import jp.vmi.selenium.selenese.command.RemoveSelection;
import jp.vmi.selenium.selenese.command.Rollup;
import jp.vmi.selenium.selenese.command.RunScript;
import jp.vmi.selenium.selenese.command.Select;
import jp.vmi.selenium.selenese.command.SelectFrame;
import jp.vmi.selenium.selenese.command.SelectPopUp;
import jp.vmi.selenium.selenese.command.SelectWindow;
import jp.vmi.selenium.selenese.command.SetCursorPosition;
import jp.vmi.selenium.selenese.command.SetSpeed;
import jp.vmi.selenium.selenese.command.SetTimeout;
import jp.vmi.selenium.selenese.command.ShiftKeyDown;
import jp.vmi.selenium.selenese.command.ShiftKeyUp;
import jp.vmi.selenium.selenese.command.Store;
import jp.vmi.selenium.selenese.command.StoreFor;
import jp.vmi.selenium.selenese.command.Submit;
import jp.vmi.selenium.selenese.command.Type;
import jp.vmi.selenium.selenese.command.TypeKeys;
import jp.vmi.selenium.selenese.command.Uncheck;
import jp.vmi.selenium.selenese.command.UseXpathLibrary;
import jp.vmi.selenium.selenese.command.WaitForCondition;
import jp.vmi.selenium.selenese.command.WaitForPageToLoad;
import jp.vmi.selenium.selenese.command.WaitForPopUp;
import jp.vmi.selenium.selenese.command.While;
import jp.vmi.selenium.selenese.command.WindowFocus;
import jp.vmi.selenium.selenese.command.WindowMaximize;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.subcommand.SubCommandMap;
import org.apache.commons.lang3.StringUtils;

public class CommandFactory
implements ICommandFactory {
    private static final Map<String, Constructor<? extends ICommand>> constructorMap = new HashMap<String, Constructor<? extends ICommand>>();
    private static final String AND_WAIT = "AndWait";
    private static final Pattern COMMAND_PATTERN;
    private static final int ASSERTION = 1;
    private static final int IS_INVERSE = 2;
    private static final int TARGET = 3;
    private static final int IS_PRESENT_INVERSE = 4;
    private static final int PRESENT = 5;
    private final List<ICommandFactory> commandFactories = new ArrayList<ICommandFactory>();
    private Context context = null;

    private static void addConstructor(Class<? extends ICommand> cmdClass, String ... aliases) {
        try {
            String name = StringUtils.uncapitalize((String)cmdClass.getSimpleName());
            Constructor<? extends ICommand> constructor = cmdClass.getDeclaredConstructor(Integer.TYPE, String.class, String[].class);
            constructorMap.put(name, constructor);
            for (String alias : aliases) {
                constructorMap.put(alias, constructor);
            }
        }
        catch (Exception e) {
            throw new SeleneseRunnerRuntimeException(e);
        }
    }

    public CommandFactory(Context context) {
        this.context = context;
    }

    public void registerCommandFactory(ICommandFactory factory) {
        this.commandFactories.add(factory);
    }

    @Override
    public ICommand newCommand(int index, String name, String ... args) {
        for (ICommandFactory factory : this.commandFactories) {
            ICommand command = factory.newCommand(index, name, args);
            if (command == null) continue;
            return command;
        }
        boolean andWait = name.endsWith(AND_WAIT);
        String realName = andWait ? name.substring(0, name.length() - AND_WAIT.length()) : name;
        Constructor<? extends ICommand> constructor = constructorMap.get(realName);
        if (constructor != null) {
            try {
                return constructor.newInstance(index, name, args);
            }
            catch (Exception e) {
                throw new SeleneseRunnerRuntimeException(e);
            }
        }
        SubCommandMap subCommandMap = this.context.getSubCommandMap();
        ISubCommand<?> subCommand = subCommandMap.get(realName);
        if (subCommand != null) {
            return new BuiltInCommand(index, name, args, subCommand, andWait);
        }
        Matcher matcher = COMMAND_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new SeleneseRunnerRuntimeException("No such command: " + name);
        }
        String assertion = matcher.group(1);
        String target = matcher.group(3);
        if (target == null) {
            target = "Expression";
        }
        if (matcher.group(5) != null) {
            target = target + "Present";
        }
        boolean isBoolean = false;
        String getter = "get" + target;
        ISubCommand<?> getterSubCommand = subCommandMap.get(getter);
        if (getterSubCommand == null) {
            getter = "is" + target;
            getterSubCommand = subCommandMap.get(getter);
            if (getterSubCommand == null) {
                throw new SeleneseRunnerRuntimeException("No such command: " + name);
            }
            isBoolean = true;
        }
        if (assertion != null) {
            boolean isInverse = matcher.group(2) != null || matcher.group(4) != null;
            return new Assertion(index, name, args, assertion, getterSubCommand, isBoolean, isInverse);
        }
        return new Store(index, name, args, getterSubCommand);
    }

    public static Set<Map.Entry<String, Constructor<? extends ICommand>>> getCommandEntries() {
        return Collections.unmodifiableSet(constructorMap.entrySet());
    }

    static {
        CommandFactory.addConstructor(AddLocationStrategy.class, new String[0]);
        CommandFactory.addConstructor(AddSelection.class, new String[0]);
        CommandFactory.addConstructor(AllowNativeXpath.class, new String[0]);
        CommandFactory.addConstructor(AltKeyDown.class, new String[0]);
        CommandFactory.addConstructor(AltKeyUp.class, new String[0]);
        CommandFactory.addConstructor(AnswerOnNextPrompt.class, new String[0]);
        CommandFactory.addConstructor(AssignId.class, new String[0]);
        CommandFactory.addConstructor(AttachFile.class, new String[0]);
        CommandFactory.addConstructor(CaptureEntirePageScreenshot.class, new String[0]);
        CommandFactory.addConstructor(Check.class, new String[0]);
        CommandFactory.addConstructor(ChooseCancelOnNextConfirmation.class, new String[0]);
        CommandFactory.addConstructor(ChooseOkOnNextConfirmation.class, new String[0]);
        CommandFactory.addConstructor(Click.class, new String[0]);
        CommandFactory.addConstructor(ClickAt.class, new String[0]);
        CommandFactory.addConstructor(Close.class, new String[0]);
        CommandFactory.addConstructor(ControlKeyDown.class, new String[0]);
        CommandFactory.addConstructor(ControlKeyUp.class, new String[0]);
        CommandFactory.addConstructor(CreateCookie.class, new String[0]);
        CommandFactory.addConstructor(DeleteAllVisibleCookies.class, new String[0]);
        CommandFactory.addConstructor(DeleteCookie.class, new String[0]);
        CommandFactory.addConstructor(DeselectPopUp.class, new String[0]);
        CommandFactory.addConstructor(DoubleClick.class, new String[0]);
        CommandFactory.addConstructor(DragAndDrop.class, "dragdrop");
        CommandFactory.addConstructor(DragAndDropToObject.class, new String[0]);
        CommandFactory.addConstructor(Echo.class, new String[0]);
        CommandFactory.addConstructor(EditContent.class, new String[0]);
        CommandFactory.addConstructor(FireEvent.class, new String[0]);
        CommandFactory.addConstructor(Focus.class, new String[0]);
        CommandFactory.addConstructor(GoBack.class, new String[0]);
        CommandFactory.addConstructor(Highlight.class, new String[0]);
        CommandFactory.addConstructor(KeyDown.class, new String[0]);
        CommandFactory.addConstructor(KeyPress.class, new String[0]);
        CommandFactory.addConstructor(KeyUp.class, new String[0]);
        CommandFactory.addConstructor(MetaKeyDown.class, new String[0]);
        CommandFactory.addConstructor(MetaKeyUp.class, new String[0]);
        CommandFactory.addConstructor(Open.class, new String[0]);
        CommandFactory.addConstructor(OpenWindow.class, new String[0]);
        CommandFactory.addConstructor(Pause.class, new String[0]);
        CommandFactory.addConstructor(Refresh.class, new String[0]);
        CommandFactory.addConstructor(RemoveAllSelections.class, new String[0]);
        CommandFactory.addConstructor(RemoveSelection.class, new String[0]);
        CommandFactory.addConstructor(Rollup.class, new String[0]);
        CommandFactory.addConstructor(RunScript.class, new String[0]);
        CommandFactory.addConstructor(Select.class, new String[0]);
        CommandFactory.addConstructor(SelectFrame.class, new String[0]);
        CommandFactory.addConstructor(SelectPopUp.class, new String[0]);
        CommandFactory.addConstructor(SelectWindow.class, new String[0]);
        CommandFactory.addConstructor(SetCursorPosition.class, new String[0]);
        CommandFactory.addConstructor(SetSpeed.class, new String[0]);
        CommandFactory.addConstructor(SetTimeout.class, new String[0]);
        CommandFactory.addConstructor(ShiftKeyDown.class, new String[0]);
        CommandFactory.addConstructor(ShiftKeyUp.class, new String[0]);
        CommandFactory.addConstructor(Submit.class, new String[0]);
        CommandFactory.addConstructor(Type.class, new String[0]);
        CommandFactory.addConstructor(TypeKeys.class, "sendKeys");
        CommandFactory.addConstructor(Uncheck.class, new String[0]);
        CommandFactory.addConstructor(UseXpathLibrary.class, new String[0]);
        CommandFactory.addConstructor(WaitForCondition.class, new String[0]);
        CommandFactory.addConstructor(WaitForPageToLoad.class, new String[0]);
        CommandFactory.addConstructor(WaitForPopUp.class, new String[0]);
        CommandFactory.addConstructor(WindowFocus.class, new String[0]);
        CommandFactory.addConstructor(WindowMaximize.class, new String[0]);
        CommandFactory.addConstructor(While.class, new String[0]);
        CommandFactory.addConstructor(EndWhile.class, new String[0]);
        CommandFactory.addConstructor(AddCollection.class, new String[0]);
        CommandFactory.addConstructor(AddToCollection.class, new String[0]);
        CommandFactory.addConstructor(StoreFor.class, new String[0]);
        CommandFactory.addConstructor(EndFor.class, new String[0]);
        CommandFactory.addConstructor(Label.class, new String[0]);
        CommandFactory.addConstructor(Gotolabel.class, "gotoLabel");
        CommandFactory.addConstructor(GotoIf.class, new String[0]);
        CommandFactory.addConstructor(Comment.class, new String[0]);
        CommandFactory.addConstructor(Include.class, new String[0]);
        COMMAND_PATTERN = Pattern.compile("(?:(assert|verify|waitFor)(Not)?|store)(?:(.+?)(?:(Not)?(Present))?)?", 2);
    }
}

