/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.StartMarker;
import jp.vmi.selenium.selenese.result.CommandResult;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import org.apache.commons.io.FilenameUtils;

public class Include
extends AbstractCommand {
    private static final int ARG_FILENAME = 0;

    Include(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        Selenese child;
        TestCase current = context.getCurrentTestCase();
        String filename = context.getVarsMap().replaceVars(curArgs[0]);
        if (FilenameUtils.getPrefixLength((String)filename) == 0) {
            String path = FilenameUtils.getFullPathNoEndSeparator((String)current.getFilename());
            filename = FilenameUtils.concat((String)path, (String)filename);
        }
        if ((child = Parser.parse(filename, context.getCommandFactory())) instanceof TestCase) {
            String seq = context.getCommandListIterator().getCommandSequence().toString();
            StartMarker marker = new StartMarker(this, "Start: " + filename);
            long now = System.currentTimeMillis();
            CommandResult markerResult = new CommandResult(seq, marker, marker.getScreenshots(), marker.getResult(), now, now);
            current.getResultList().add(markerResult);
            try {
                Result result = child.execute(current, context);
                return result == Success.SUCCESS ? new Success("Success: " + filename) : result;
            }
            catch (InvalidSeleneseException e) {
                return new Error(e);
            }
        }
        return new Error("TestCase expected: " + filename);
    }
}

