/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.List;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.locator.OptionLocator;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SelectElement {
    private final WebDriverElementFinder finder;
    public final WebElement select;
    public final boolean isMultiple;

    public SelectElement(Context context, String selectLocator) {
        WebDriver driver = context.getWrappedDriver();
        this.finder = context.getElementFinder();
        this.select = this.finder.findElement(driver, selectLocator);
        context.getJSLibrary().replaceAlertMethod(driver, this.select);
        String multiple = this.select.getAttribute("multiple");
        this.isMultiple = multiple != null && (multiple.equalsIgnoreCase("true") || multiple.equalsIgnoreCase("multiple"));
    }

    public void unsetOptions() {
        for (WebElement option : this.select.findElements(By.tagName((String)"option"))) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void selectOptions(String optionLocator, boolean doSelect) {
        List<WebElement> options = this.finder.findOptions(this.select, new OptionLocator(optionLocator));
        for (WebElement option : options) {
            if (!(doSelect ^ option.isSelected())) continue;
            option.click();
        }
    }
}

