/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ModifierKeyState;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.result.Warning;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Type
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final int ARG_VALUE = 1;

    Type(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        ModifierKeyState state = context.getModifierKeyState();
        if (state.isControlKeyDown() || state.isAltKeyDown() || state.isMetaKeyDown()) {
            throw new SeleneseRunnerRuntimeException("type not supported immediately after call to controlKeyDown() or altKeyDown() or metaKeyDown()");
        }
        String locator = curArgs[0];
        String value = curArgs[1];
        if (state.isShiftKeyDown()) {
            value = value.toUpperCase();
        }
        WebDriver driver = context.getWrappedDriver();
        WebElement element = context.getElementFinder().findElement(driver, locator);
        context.getJSLibrary().replaceAlertMethod(driver, element);
        String tagName = element.getTagName().toLowerCase();
        Result result = Success.SUCCESS;
        switch (tagName) {
            case "input": {
                String type = element.getAttribute("type");
                if (type != null && "file".equalsIgnoreCase(type)) {
                    result = new Warning("You should be using attachFile to set the value of a file input element");
                }
                element.clear();
                element.sendKeys(new CharSequence[]{value});
                break;
            }
            default: {
                ((JavascriptExecutor)driver).executeScript("arguments[0].value = '';", new Object[]{element});
                element.sendKeys(new CharSequence[]{value});
            }
        }
        context.getJSLibrary().fireEvent(driver, element, "change");
        return result;
    }
}

