/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.Wait;

public class WaitForCondition
extends AbstractCommand {
    private static final int ARG_SCRIPT = 0;
    private static final int ARG_TIMEOUT = 1;

    WaitForCondition(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE, ArgumentType.VALUE);
    }

    @Override
    public boolean mayUpdateScreen() {
        return false;
    }

    @Override
    protected Result executeImpl(final Context context, String ... curArgs) {
        final String script = curArgs[0];
        long timeout = Long.valueOf(curArgs[1]);
        long startTime = System.currentTimeMillis();
        boolean waitResult = Wait.defaultInterval.wait(startTime, timeout, new Wait.StopCondition(){

            @Override
            public boolean isSatisfied() {
                Object result = context.getEval().eval(context, script);
                if (result == null) {
                    return false;
                }
                if (result instanceof String) {
                    return !((String)result).isEmpty();
                }
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return true;
            }
        });
        if (waitResult) {
            return Success.SUCCESS;
        }
        return new Error("Timed out after " + timeout + "ms");
    }
}

