/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.highlight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.vmi.selenium.selenese.locator.Locator;
import jp.vmi.selenium.selenese.locator.WebDriverElementFinder;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class HighlightStyle {
    public static HighlightStyle[] ELEMENT_STYLES = new HighlightStyle[]{new HighlightStyle("backgroundColor: yellow", "outline: #8f8 solid 1px"), new HighlightStyle("backgroundColor: orange", "outline: #484 solid 1px")};
    private static final String SCRIPT = "return (function(element, hlStyle) {\n  var backup = {};\n  var style = element.style;\n  for (var key in hlStyle) {\n    backup[key] = style[key];\n    style[key] = hlStyle[key];\n  }\n  return backup;\n}).apply(window, arguments);";
    private final Map<String, String> styles;

    public HighlightStyle(Map<String, String> styles) {
        this.styles = styles;
    }

    public HighlightStyle(String ... styles) {
        this.styles = new HashMap<String, String>();
        for (String style : styles) {
            String[] kv = style.split("\\s*:\\s*", 2);
            this.styles.put(kv[0], kv[1]);
        }
    }

    public Map<String, String> doHighlight(WebDriver driver, WebDriverElementFinder elementFinder, Locator ploc, List<Locator> selectedFrameLocators) {
        try {
            WebElement element = elementFinder.findElement(driver, ploc, selectedFrameLocators);
            Object result = ((JavascriptExecutor)driver).executeScript(SCRIPT, new Object[]{element, this.styles});
            return result instanceof Map ? (Map)result : null;
        }
        catch (RuntimeException e) {
            if (SeleniumUtils.isElementNotFound(e)) {
                return null;
            }
            throw e;
        }
    }
}

