/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.javascript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class JSFunction {
    private final String function;
    private static final Pattern BEGIN_RE = Pattern.compile("function\\s+(?<name>\\w+)\\((?<args>.*?)\\).*");
    private static final Pattern END_RE = Pattern.compile("\\}.*");

    private JSFunction(String function) {
        this.function = function;
    }

    public static Map<String, JSFunction> load(InputStream is) {
        HashMap<String, JSFunction> functions = new HashMap<String, JSFunction>();
        String name = null;
        boolean hasArgs = false;
        StringBuilder body = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (name == null) {
                    Matcher matcher = BEGIN_RE.matcher(line);
                    if (!matcher.matches()) continue;
                    name = matcher.group("name");
                    String args = matcher.group("args");
                    hasArgs = !args.isEmpty();
                    if (hasArgs) {
                        body = new StringBuilder("return (function(" + args + "){");
                        continue;
                    }
                    body = new StringBuilder();
                    continue;
                }
                if (END_RE.matcher(line).matches()) {
                    if (hasArgs) {
                        body.append("}).apply(null, arguments)");
                    }
                    functions.put(name, new JSFunction(body.toString()));
                    name = null;
                    body = null;
                    hasArgs = false;
                    continue;
                }
                body.append(line.trim()).append('\n');
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return functions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSFunction loadFunction(InputStream is) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String body = br.lines().collect(Collectors.joining("\n", "return (", ").apply(null, arguments);"));
            JSFunction jSFunction = new JSFunction(body);
            return jSFunction;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T call(WebDriver driver, Object ... args) {
        Object result = ((JavascriptExecutor)driver).executeScript(this.function, args);
        return (T)result;
    }
}

