/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.mutator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.mutator.FunctionDeclaration;
import jp.vmi.selenium.selenese.mutator.ScriptMutator;
import jp.vmi.selenium.selenese.mutator.VariableDeclaration;
import jp.vmi.selenium.selenese.mutator.VariableDeclarationWithDynamicValue;

public class SeleneseRunnerMutator
implements ScriptMutator {
    private final List<ScriptMutator> mutators = new ArrayList<ScriptMutator>();
    private static final Pattern ESC_RE = Pattern.compile("[\\\\\n']");

    public SeleneseRunnerMutator() {
        this.mutators.add(new VariableDeclaration("selenium", "{}"));
        this.mutators.add(new VariableDeclaration("selenium.browserbot", "{}"));
        this.mutators.add(new VariableDeclarationWithDynamicValue("selenium.browserbot.baseUrl", context -> context.getCurrentBaseURL()));
        this.mutators.add(new VariableDeclaration("browserVersion", "{}"));
        this.mutators.add(new VariableDeclaration("browserVersion.isFirefox", "navigator.userAgent.indexOf('Firefox') != -1 || navigator.userAgent.indexOf('Namoroka') != -1 || navigator.userAgent.indexOf('Shiretoko') != -1"));
        this.mutators.add(new VariableDeclaration("browserVersion.isGecko", "navigator.userAgent.indexOf('Firefox') != -1 || navigator.userAgent.indexOf('Namoroka') != -1 || navigator.userAgent.indexOf('Shiretoko') != -1"));
        this.mutators.add(new VariableDeclaration("browserVersion.firefoxVersion", "(function() {var r = /.*[Firefox|Namoroka|Shiretoko]\\/([\\d\\.]+).*/.exec(navigator.userAgent);return r ? r[1] : '';})()"));
        this.mutators.add(new VariableDeclaration("browserVersion.isIE", "navigator.appName == 'Microsoft Internet Explorer'"));
        this.mutators.add(new FunctionDeclaration("selenium.page", "if (!selenium.browserbot) { selenium.browserbot = {} }; return selenium.browserbot;"));
        this.mutators.add(new FunctionDeclaration("selenium.browserbot.getCurrentWindow", "return window;"));
        this.mutators.add(new FunctionDeclaration("selenium.browserbot.getUserWindow", "return window;"));
        this.mutators.add(new FunctionDeclaration("selenium.page().getCurrentWindow", "return window;"));
        this.mutators.add(new FunctionDeclaration("selenium.browserbot.getDocument", "return document;"));
        this.mutators.add(new FunctionDeclaration("selenium.page().getDocument", "return document;"));
    }

    @Override
    public void mutate(Context context, String script, StringBuilder outputTo) {
        StringBuilder nested = new StringBuilder();
        for (ScriptMutator mutator : this.mutators) {
            mutator.mutate(context, script, nested);
        }
        nested.append(script);
        outputTo.append("return eval('");
        this.escape(nested, outputTo);
        outputTo.append("');");
    }

    private void escape(CharSequence escape, StringBuilder outputTo) {
        Matcher matcher = ESC_RE.matcher(escape);
        int start = 0;
        while (matcher.find(start)) {
            if (start < matcher.start()) {
                outputTo.append(escape.subSequence(start, matcher.start()));
            }
            switch (matcher.group()) {
                case "\\": {
                    outputTo.append("\\\\");
                    break;
                }
                case "\n": {
                    outputTo.append("\\n");
                    break;
                }
                case "'": {
                    outputTo.append("\\'");
                }
            }
            start = matcher.end();
        }
        if (start < escape.length()) {
            outputTo.append(escape.subSequence(start, escape.length()));
        }
    }
}

