/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.result;

import java.util.regex.Pattern;

public abstract class Result
implements Comparable<Result> {
    private static final Pattern SKIP_RE = Pattern.compile("ByGuice|^com\\.google\\.inject\\.|^java\\.lang\\.reflect\\.|^sun\\.reflect\\.|^org\\.junit\\.|^org\\.eclipse\\.jdt\\.");
    private final String message;

    public Result(String message) {
        this.message = message;
    }

    public Result(String prefix, String message) {
        this.message = prefix + ": " + message;
    }

    public Result(String prefix, Exception e) {
        this.message = this.generateExceptionMessage(prefix, e);
    }

    public Result(String prefix, String message, Exception e) {
        StringBuilder result = new StringBuilder(prefix).append(": ").append(message).append(" - ");
        this.message = this.generateExceptionMessage(result, e);
    }

    protected String generateExceptionMessage(String prefix, Exception e) {
        return this.generateExceptionMessage(new StringBuilder(prefix).append(": "), e);
    }

    protected String generateExceptionMessage(StringBuilder result, Exception e) {
        String msg = e.getMessage();
        if (msg != null) {
            result.append(e.getClass().getSimpleName()).append(" - ").append(msg);
        } else {
            result.append(e.getClass().getName());
        }
        result.append(" (");
        boolean sep = false;
        for (StackTraceElement stackTrace : e.getStackTrace()) {
            String className = stackTrace.getClassName();
            if (className == null || SKIP_RE.matcher(className).find()) continue;
            if (sep) {
                result.append(" / ");
            }
            result.append(className.replaceFirst("^.*\\.", "")).append('.').append(stackTrace.getMethodName());
            String fileName = stackTrace.getFileName();
            if (fileName != null) {
                result.append('(').append(fileName);
                int lineNumber = stackTrace.getLineNumber();
                if (lineNumber >= 0) {
                    result.append(':').append(lineNumber);
                }
                result.append(')');
            }
            sep = true;
        }
        result.append(")");
        return result.toString();
    }

    public abstract Level getLevel();

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.getLevel() == Level.SUCCESS;
    }

    public boolean isAborted() {
        return this.getLevel().value >= Level.FAILURE.value;
    }

    public boolean isFailed() {
        return this.getLevel().value >= Level.WARNING.value;
    }

    public Result update(Result newResult) {
        return newResult.getLevel().value > this.getLevel().value ? newResult : this;
    }

    @Override
    public int compareTo(Result result) {
        return this.getLevel().compareTo(result.getLevel());
    }

    public String toString() {
        return "[" + this.message + "]";
    }

    public static enum Level {
        UNEXECUTED(-1, 0, 5),
        SUCCESS(0, 0, 0),
        WARNING(1, 0, 2),
        FAILURE(2, 3, 3),
        ERROR(3, 3, 4),
        MAX_TIME_EXCEEDED(4, 3, 6);

        public final int value;
        public final int exitCode;
        public final int strictExitCode;

        private Level(int value, int exitCode, int strictExitCode) {
            this.value = value;
            this.exitCode = exitCode;
            this.strictExitCode = strictExitCode;
        }
    }
}

