/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.GetAlert;
import jp.vmi.selenium.selenese.subcommand.GetAllButtons;
import jp.vmi.selenium.selenese.subcommand.GetAllFields;
import jp.vmi.selenium.selenese.subcommand.GetAllLinks;
import jp.vmi.selenium.selenese.subcommand.GetAllWindowNames;
import jp.vmi.selenium.selenese.subcommand.GetAllWindowTitles;
import jp.vmi.selenium.selenese.subcommand.GetAttribute;
import jp.vmi.selenium.selenese.subcommand.GetAttributeFromAllWindows;
import jp.vmi.selenium.selenese.subcommand.GetBodyText;
import jp.vmi.selenium.selenese.subcommand.GetConfirmation;
import jp.vmi.selenium.selenese.subcommand.GetCookie;
import jp.vmi.selenium.selenese.subcommand.GetCookieByName;
import jp.vmi.selenium.selenese.subcommand.GetCssCount;
import jp.vmi.selenium.selenese.subcommand.GetCursorPosition;
import jp.vmi.selenium.selenese.subcommand.GetElementHeight;
import jp.vmi.selenium.selenese.subcommand.GetElementIndex;
import jp.vmi.selenium.selenese.subcommand.GetElementPositionLeft;
import jp.vmi.selenium.selenese.subcommand.GetElementPositionTop;
import jp.vmi.selenium.selenese.subcommand.GetElementWidth;
import jp.vmi.selenium.selenese.subcommand.GetEval;
import jp.vmi.selenium.selenese.subcommand.GetExpression;
import jp.vmi.selenium.selenese.subcommand.GetHtmlSource;
import jp.vmi.selenium.selenese.subcommand.GetLocation;
import jp.vmi.selenium.selenese.subcommand.GetPrompt;
import jp.vmi.selenium.selenese.subcommand.GetSelectOptions;
import jp.vmi.selenium.selenese.subcommand.GetSelected;
import jp.vmi.selenium.selenese.subcommand.GetSpeed;
import jp.vmi.selenium.selenese.subcommand.GetTable;
import jp.vmi.selenium.selenese.subcommand.GetText;
import jp.vmi.selenium.selenese.subcommand.GetTitle;
import jp.vmi.selenium.selenese.subcommand.GetValue;
import jp.vmi.selenium.selenese.subcommand.GetXpathCount;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.subcommand.IsAlertPresent;
import jp.vmi.selenium.selenese.subcommand.IsChecked;
import jp.vmi.selenium.selenese.subcommand.IsConfirmationPresent;
import jp.vmi.selenium.selenese.subcommand.IsCookiePresent;
import jp.vmi.selenium.selenese.subcommand.IsEditable;
import jp.vmi.selenium.selenese.subcommand.IsElementPresent;
import jp.vmi.selenium.selenese.subcommand.IsOrdered;
import jp.vmi.selenium.selenese.subcommand.IsPromptPresent;
import jp.vmi.selenium.selenese.subcommand.IsSomethingSelected;
import jp.vmi.selenium.selenese.subcommand.IsTextPresent;
import jp.vmi.selenium.selenese.subcommand.IsVisible;
import jp.vmi.selenium.selenese.subcommand.MouseEventHandler;
import jp.vmi.selenium.selenese.subcommand.NoOp;

public class SubCommandMap {
    private final Map<String, ISubCommand<?>> subCommands = new HashMap();

    public SubCommandMap() {
        this.register(new GetAlert());
        this.register(new GetAllButtons());
        this.register(new GetAllFields());
        this.register(new GetAllLinks());
        this.register(new GetAllWindowNames());
        this.register(new GetAllWindowTitles());
        this.register(new GetAttribute());
        this.register(new GetAttributeFromAllWindows());
        this.register(new GetBodyText());
        this.register(new GetConfirmation());
        this.register(new GetCookie());
        this.register(new GetCookieByName());
        this.register(new GetCssCount());
        this.register(new GetCursorPosition());
        this.register(new GetElementHeight());
        this.register(new GetElementIndex());
        this.register(new GetElementPositionLeft());
        this.register(new GetElementPositionTop());
        this.register(new GetElementWidth());
        this.register(new GetEval());
        this.register(new GetExpression());
        this.register(new GetHtmlSource());
        this.register(new GetLocation());
        this.register(new GetPrompt());
        this.register(new GetSelectOptions());
        this.register(new GetSpeed());
        this.register(new GetTable());
        this.register(new GetText());
        this.register(new GetTitle());
        this.register(new GetValue());
        this.register(new GetXpathCount());
        this.register(new IsAlertPresent());
        this.register(new IsChecked());
        this.register(new IsConfirmationPresent());
        this.register(new IsCookiePresent());
        this.register(new IsEditable());
        this.register(new IsElementPresent());
        this.register(new IsOrdered());
        this.register(new IsPromptPresent());
        this.register(new IsSomethingSelected());
        this.register(new IsTextPresent());
        this.register(new IsVisible());
        for (MouseEventHandler.MouseEventType type : MouseEventHandler.MouseEventType.values()) {
            this.register(new MouseEventHandler(type));
        }
        this.register(new GetSelected(GetSelected.Type.LABEL, false));
        this.register(new GetSelected(GetSelected.Type.LABEL, true));
        this.register(new GetSelected(GetSelected.Type.VALUE, false));
        this.register(new GetSelected(GetSelected.Type.VALUE, true));
        this.register(new GetSelected(GetSelected.Type.INDEX, false));
        this.register(new GetSelected(GetSelected.Type.INDEX, true));
        this.register(new GetSelected(GetSelected.Type.ID, false));
        this.register(new GetSelected(GetSelected.Type.ID, true));
        this.register(new NoOp("setBrowserLogLevel", ArgumentType.VALUE));
        this.register(new NoOp("waitForFrameToLoad", ArgumentType.VALUE, ArgumentType.VALUE));
    }

    public void register(ISubCommand<?> subCommand) {
        this.register(subCommand, subCommand.getName());
    }

    public void register(ISubCommand<?> subCommand, String name) {
        this.subCommands.put(name, subCommand);
    }

    public ISubCommand<?> get(String commandName) {
        return this.subCommands.get(commandName);
    }

    public Map<String, ISubCommand<?>> getMap() {
        return Collections.unmodifiableMap(this.subCommands);
    }
}

