/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;

public class SeleniumUtils {
    private static final DecimalFormatSymbols US_FORMAT = DecimalFormatSymbols.getInstance(Locale.US);

    private SeleniumUtils() {
    }

    public static boolean patternMatches(String pattern, CharSequence input) {
        return new SeleniumPattern(pattern).matches(input.toString());
    }

    public static String normalizeSpaces(String str) {
        int si = str.indexOf(32);
        int ni = str.indexOf(160);
        if (si < 0 && ni < 0) {
            return str;
        }
        int len = str.length();
        StringBuilder buf = new StringBuilder(len);
        boolean skipSpc = true;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\u00a0') {
                buf.append(c);
                skipSpc = false;
                continue;
            }
            if (skipSpc) continue;
            buf.append(' ');
            skipSpc = true;
        }
        int blen = buf.length();
        if (blen > 0 && buf.charAt(blen - 1) == ' ') {
            buf.deleteCharAt(blen - 1);
        }
        return buf.toString();
    }

    public static String doubleToString(double d) {
        if (d % 1.0 == 0.0) {
            return new DecimalFormat("0", US_FORMAT).format(d);
        }
        return Double.toString(d);
    }

    public static <T> String convertToString(T result) {
        if (result == null) {
            return "";
        }
        if (result instanceof Object[]) {
            return StringUtils.join((Object[])((Object[])result), (char)',');
        }
        if (result instanceof Iterable) {
            return StringUtils.join((Iterable)((Iterable)result), (char)',');
        }
        if (result instanceof Iterator) {
            return StringUtils.join((Iterator)((Iterator)result), (char)',');
        }
        if (result instanceof Double) {
            return SeleniumUtils.doubleToString((Double)result);
        }
        return result.toString();
    }

    public static boolean isElementNotFound(RuntimeException e) {
        return e instanceof NotFoundException || e instanceof StaleElementReferenceException || e.getCause() instanceof NotFoundException || e.getCause() instanceof StaleElementReferenceException;
    }

    public static class SeleniumPattern {
        public final Type type;
        public final Pattern regexpPattern;
        public final String stringPattern;

        public SeleniumPattern(String pattern) {
            String[] p = pattern.split(":", 2);
            if (p.length == 2) {
                String type = p[0].toLowerCase();
                if ("regexp".equals(type)) {
                    this.type = Type.REGEXP;
                    this.regexpPattern = Pattern.compile(p[1]);
                    this.stringPattern = p[1];
                    return;
                }
                if ("regexpi".equals(type)) {
                    this.type = Type.REGEXPI;
                    this.regexpPattern = Pattern.compile(p[1], 2);
                    this.stringPattern = p[1];
                    return;
                }
                if ("glob".equals(type)) {
                    pattern = p[1];
                } else if ("exact".equals(type)) {
                    this.type = Type.EXACT;
                    this.regexpPattern = null;
                    this.stringPattern = p[1];
                    return;
                }
            }
            if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
                int len;
                this.type = Type.GLOB;
                StringBuilder re = new StringBuilder("\\A\\Q");
                re.append(pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
                if (re.length() >= 6 && re.charAt(4) == '\\' && re.charAt(5) == 'E') {
                    re.delete(2, 6);
                }
                if (re.charAt((len = re.length()) - 2) == '\\' && re.charAt(len - 1) == 'Q') {
                    re.setCharAt(re.length() - 1, 'z');
                } else {
                    re.append("\\E\\z");
                }
                this.regexpPattern = Pattern.compile(re.toString(), 32);
            } else {
                this.type = Type.EXACT;
                this.regexpPattern = null;
            }
            this.stringPattern = pattern;
        }

        public boolean matches(String input) {
            input = SeleniumUtils.normalizeSpaces(input);
            switch (this.type) {
                case REGEXP: 
                case REGEXPI: 
                case GLOB: {
                    return this.regexpPattern.matcher(input).find();
                }
                case EXACT: {
                    return SeleniumUtils.normalizeSpaces(this.stringPattern).equals(input);
                }
            }
            throw new UnsupportedOperationException(this.type.toString());
        }

        public String toString() {
            return "SeleniumPattern[" + (Object)((Object)this.type) + ":" + StringEscapeUtils.escapeJava((String)this.stringPattern) + "]";
        }

        public static enum Type {
            REGEXP,
            REGEXPI,
            GLOB,
            EXACT;

        }
    }
}

