/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.time.Duration;
import jp.vmi.selenium.selenese.utils.DateTimeUtils;

public class StopWatch {
    private long startTime;
    private long endTime;

    public void start() {
        this.start(System.currentTimeMillis());
    }

    public void start(long currentTimeMillis) {
        this.startTime = this.endTime = currentTimeMillis;
    }

    public void end() {
        this.end(System.currentTimeMillis());
    }

    public void end(long currentTimeMillis) {
        this.endTime = currentTimeMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public String getDurationString() {
        StringBuilder ds = new StringBuilder();
        Duration d = Duration.ofMillis(this.endTime - this.startTime);
        long h = d.toHours();
        if (h > 0L) {
            ds.append(h).append("hour");
        }
        long m = d.toMinutes() % 60L;
        if (ds.length() > 0) {
            ds.append('/').append(m).append("min");
        } else if (m > 0L) {
            ds.append(m).append("min");
        }
        long s = d.getSeconds() % 60L;
        double ms = (double)(d.toMillis() % 1000L) / 1000.0;
        if (ds.length() > 0) {
            ds.append('/');
        }
        ds.append(String.format("%.3fsec", (double)s + ms));
        return ds.toString();
    }

    public String getStartTimeString() {
        return DateTimeUtils.formatWithMS(this.startTime);
    }

    public String getEndTimeString() {
        return DateTimeUtils.formatWithMS(this.endTime);
    }
}

