/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.exec.OS;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class IEDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "ie";

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    @Override
    public boolean isProxySupported() {
        return false;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        if (!OS.isFamilyWindows()) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.internetExplorer(), driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
            String executable = PathUtils.normalize(driverOptions.get(DriverOptions.DriverOption.IEDRIVER));
            if (!new File(executable).canExecute()) {
                throw new IllegalArgumentException("Missing IEDriverServer: " + executable);
            }
            System.setProperty("webdriver.ie.driver", executable);
        }
        InternetExplorerDriverService service = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)((InternetExplorerDriverService.Builder)new InternetExplorerDriverService.Builder().usingAnyFreePort()).withEnvironment(driverOptions.getEnvVars())).build();
        caps.merge((Capabilities)driverOptions.getCapabilities());
        InternetExplorerDriver driver = new InternetExplorerDriver(service, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

