/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import jp.vmi.selenium.webdriver.ChromeDriverFactory;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.FirefoxDriverFactory;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWebDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "remote";
    private static final Logger log = LoggerFactory.getLogger(RemoteWebDriverFactory.class);

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        URL url;
        DesiredCapabilities caps = DesiredCapabilities.htmlUnit();
        this.setupProxy(caps, driverOptions);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_BROWSER)) {
            String browser = driverOptions.get(DriverOptions.DriverOption.REMOTE_BROWSER);
            caps.setBrowserName(browser);
            log.info("Remote browser: {}", (Object)browser);
            if ("firefox".equalsIgnoreCase(browser)) {
                FirefoxDriverFactory.setDriverSpecificCapabilitiesForRemoteWebDriver(caps, driverOptions);
            }
            if ("chrome".equalsIgnoreCase(browser)) {
                ChromeDriverFactory.setDriverSpecificCapabilities(caps, driverOptions);
            }
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_PLATFORM)) {
            String platform = driverOptions.get(DriverOptions.DriverOption.REMOTE_PLATFORM);
            caps.setCapability("platform", platform);
            log.info("Remote platform: {}", (Object)platform);
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_VERSION)) {
            String version = driverOptions.get(DriverOptions.DriverOption.REMOTE_VERSION);
            caps.setCapability("version", version);
            log.info("Remote version: {}", (Object)version);
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_URL)) {
            try {
                url = new URL(driverOptions.get(DriverOptions.DriverOption.REMOTE_URL));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid --remote-url: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Require --remote-url to know where to connect to");
        }
        log.info("Remote URL: {}", (Object)url);
        RemoteWebDriver driver = new RemoteWebDriver(url, (Capabilities)caps);
        log.info("Session ID: " + driver.getSessionId());
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        driver.setFileDetector((FileDetector)new LocalFileDetector());
        return driver;
    }
}

