/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import jp.vmi.selenium.webdriver.DriverOptions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    protected static final int DEFAULT_WIDTH = 1024;
    protected static final int DEFAULT_HEIGHT = 768;

    public String getBrowserName() {
        String name = this.getClass().getSimpleName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        if (name.endsWith("WebDriverFactory")) {
            return name.substring(0, name.length() - "WebDriverFactory".length()).toLowerCase();
        }
        if (name.endsWith("DriverFactory")) {
            return name.substring(0, name.length() - "DriverFactory".length()).toLowerCase();
        }
        return name.toLowerCase();
    }

    public boolean isProxySupported() {
        return true;
    }

    protected DesiredCapabilities setupProxy(DesiredCapabilities caps, DriverOptions driverOptions) {
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            if (!this.isProxySupported()) {
                log.warn("No support proxy with {}. Please set proxy to browser configuration in advance.", (Object)this.getClass().getSimpleName().replaceFirst("Factory$", ""));
                return caps;
            }
            Proxy proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            String ps = driverOptions.get(DriverOptions.DriverOption.PROXY);
            proxy.setHttpProxy(ps).setSslProxy(ps).setFtpProxy(ps);
            if (driverOptions.has(DriverOptions.DriverOption.NO_PROXY)) {
                proxy.setNoProxy(driverOptions.get(DriverOptions.DriverOption.NO_PROXY));
            }
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public abstract WebDriver newInstance(DriverOptions var1);

    protected void setInitialWindowSize(WebDriver driver, DriverOptions driverOptions) {
        Dimension size;
        if (driverOptions.has(DriverOptions.DriverOption.WIDTH) || driverOptions.has(DriverOptions.DriverOption.HEIGHT)) {
            int width = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.WIDTH), (int)1024);
            int height = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.HEIGHT), (int)768);
            size = new Dimension(width, height);
        } else {
            size = this.getDefaultWindowSize(driver);
            if (size == null) {
                log.info("Initial window size: system default");
                return;
            }
        }
        driver.manage().window().setSize(size);
        log.info("Initial window size: {}x{}", (Object)size.width, (Object)size.height);
    }

    protected Dimension getDefaultWindowSize(WebDriver driver) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        return this == obj || this.getClass() == obj.getClass();
    }
}

