/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import jp.vmi.selenium.webdriver.AppiumWebDriverFactory;
import jp.vmi.selenium.webdriver.ChromeDriverFactory;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.FirefoxDriverFactory;
import jp.vmi.selenium.webdriver.HtmlUnitDriverFactory;
import jp.vmi.selenium.webdriver.IEDriverFactory;
import jp.vmi.selenium.webdriver.PhantomJSDriverFactory;
import jp.vmi.selenium.webdriver.RemoteWebDriverFactory;
import jp.vmi.selenium.webdriver.SafariDriverFactory;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import jp.vmi.selenium.webdriver.WebDriverPreparator;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverManager
implements WebDriverPreparator {
    private static final Logger log = LoggerFactory.getLogger(WebDriverManager.class);
    public static final String FIREFOX = "firefox";
    public static final String CHROME = "chrome";
    public static final String IE = "ie";
    public static final String HTMLUNIT = "htmlunit";
    public static final String SAFARI = "safari";
    public static final String REMOTE = "remote";
    public static final String APPIUM = "appium";
    public static final String PHANTOMJS = "phantomjs";
    public static final String WEBDRIVER_FACTORY = "jp.vmi.selenium.webdriver.factory";
    private static final Set<WebDriverManager> managers = Collections.newSetFromMap(new WeakHashMap());
    private WebDriverFactory factory;
    private DriverOptions driverOptions = new DriverOptions();
    private Builder builder = null;
    private WebDriver driver = null;

    private static String getDriverName(WebDriver driver) {
        String name = driver.getClass().getSimpleName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        return driver.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebDriverManager newInstance() {
        WebDriverManager manager = new WebDriverManager();
        Set<WebDriverManager> set = managers;
        synchronized (set) {
            managers.add(manager);
        }
        return manager;
    }

    private WebDriverManager() {
        this.setWebDriverFactory(System.getProperty(WEBDRIVER_FACTORY, FIREFOX));
    }

    @Override
    public String getBrowserName() {
        return this.factory.getBrowserName();
    }

    public void setWebDriverFactory(WebDriverFactory factory) {
        this.factory = factory;
    }

    public void setWebDriverFactory(String factoryName) {
        WebDriverFactory factory = this.lookupWebDriverFactory(factoryName);
        this.setWebDriverFactory(factory);
    }

    public WebDriverFactory lookupWebDriverFactory(String factoryName) {
        if (StringUtils.isBlank((CharSequence)factoryName)) {
            factoryName = FIREFOX;
        }
        switch (factoryName.toLowerCase()) {
            case "firefox": {
                return new FirefoxDriverFactory();
            }
            case "chrome": {
                return new ChromeDriverFactory();
            }
            case "ie": {
                return new IEDriverFactory();
            }
            case "safari": {
                return new SafariDriverFactory();
            }
            case "htmlunit": {
                return new HtmlUnitDriverFactory();
            }
            case "remote": {
                return new RemoteWebDriverFactory();
            }
            case "appium": {
                return new AppiumWebDriverFactory();
            }
            case "phantomjs": {
                return new PhantomJSDriverFactory();
            }
        }
        try {
            return (WebDriverFactory)Class.forName(factoryName).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid WebDriverFactory class name: " + factoryName, e);
        }
    }

    public DriverOptions getDriverOptions() {
        return this.driverOptions;
    }

    public void setDriverOptions(DriverOptions driverOptions) {
        this.driverOptions = driverOptions;
    }

    private boolean isBrowserUnreachable(Throwable t) {
        if (t instanceof UnreachableBrowserException) {
            return true;
        }
        String msg = t.getMessage();
        return msg != null && msg.startsWith("browser is undefined");
    }

    private boolean isDriverReusable() {
        if (this.driver == null) {
            return false;
        }
        try {
            this.driver.getWindowHandle();
            if (this.driver instanceof ChromeDriver) {
                this.driver.getTitle();
            }
            return true;
        }
        catch (NoSuchWindowException e) {
            log.info("No focused window.");
            Set handles = this.driver.getWindowHandles();
            if (!handles.isEmpty()) {
                log.info("Activate a window.");
                this.driver.switchTo().window((String)handles.iterator().next());
                return true;
            }
            log.warn("No window exists.");
        }
        catch (RuntimeException e) {
            if (!this.isBrowserUnreachable(e)) {
                throw e;
            }
            log.warn("Browser might crash.");
        }
        try {
            this.driver.quit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public synchronized WebDriver get() throws IllegalArgumentException {
        if (this.builder == null || this.builder.isParameterChanged(this.factory, this.driverOptions)) {
            this.builder = new Builder(this.factory, this.driverOptions);
        } else {
            if (this.isDriverReusable()) {
                log.info("Existing driver found.");
                return this.driver;
            }
            log.info("Restart driver.");
        }
        this.quitDriver();
        this.driver = this.builder.build();
        log.info("Initialized: {}", (Object)WebDriverManager.getDriverName(this.driver));
        return this.driver;
    }

    public synchronized void quitDriver() {
        if (this.driver == null) {
            return;
        }
        try {
            this.driver.quit();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        finally {
            log.info("Quit: {}", (Object)WebDriverManager.getDriverName(this.driver));
        }
        this.driver = null;
    }

    protected void finalize() throws Throwable {
        this.quitDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void quitDriversOnAllManagers() {
        Set<WebDriverManager> set = managers;
        synchronized (set) {
            for (WebDriverManager manager : managers) {
                manager.quitDriver();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WebDriverManager.quitDriversOnAllManagers();
            }
        });
    }

    private static class Builder {
        private final WebDriverFactory factory;
        private final DriverOptions driverOptions;

        public Builder(WebDriverFactory factory, DriverOptions driverOptions) {
            this.factory = factory;
            this.driverOptions = new DriverOptions(driverOptions);
        }

        public boolean isParameterChanged(WebDriverFactory factory, DriverOptions driverOptions) {
            return !this.factory.equals(factory) || !this.driverOptions.toString().equals(driverOptions.toString());
        }

        public WebDriver build() {
            return this.factory.newInstance(this.driverOptions);
        }
    }
}

