/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.util.ClassUtils;

public abstract class AbstractImplementationGenerator {
    protected final InterfaceMetaData interfaceMetaData;
    protected final String className;
    protected final String fullClassName;
    protected byte[] bytes;

    public AbstractImplementationGenerator(InterfaceMetaData interfaceMetaData) {
        this.className = interfaceMetaData.getName() + "Impl";
        this.fullClassName = interfaceMetaData.getPackageName() + '.' + this.className;
        this.interfaceMetaData = interfaceMetaData;
    }

    public abstract void create();

    public abstract void enhance();

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    protected void createFields() {
        InterfaceMetaData acmd = this.interfaceMetaData;
        do {
            this.createFields((AbstractClassMetaData)acmd);
        } while ((acmd = acmd.getSuperAbstractClassMetaData()) != null);
    }

    protected abstract void createFields(AbstractClassMetaData var1);

    protected void createMethods() {
        InterfaceMetaData acmd = this.interfaceMetaData;
        do {
            this.createMethods((AbstractClassMetaData)acmd);
        } while ((acmd = acmd.getSuperAbstractClassMetaData()) != null);
    }

    protected void createMethods(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return;
        }
        AbstractPropertyMetaData[] propertyMetaData = acmd.getManagedFields();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            boolean isBoolean = propertyMetaData[i].getTypeName().equals("boolean");
            this.createGetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanGetterName((String)propertyMetaData[i].getName(), (boolean)isBoolean), propertyMetaData[i].getName());
            this.createSetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanSetterName((String)propertyMetaData[i].getName()), propertyMetaData[i].getName());
        }
    }

    protected abstract void createDefaultConstructor();

    protected abstract void createGetter(String var1, String var2, String var3);

    protected abstract void createSetter(String var1, String var2, String var3);
}

