/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.bcel.util.Repository;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.PMFConfiguration;
import org.jpox.PMFContext;
import org.jpox.enhancer.ClassEnhancer;
import org.jpox.enhancer.bcel.BCELUtils;
import org.jpox.enhancer.bcel.JPOXRepository;
import org.jpox.enhancer.metadata.EnhancerMetaDataHelper;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.CommandLine;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class JPOXEnhancer
extends PMFConfiguration {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.jpox.enhancer.Localisation", (ClassLoader)(class$org$jpox$enhancer$ClassEnhancer == null ? (class$org$jpox$enhancer$ClassEnhancer = JPOXEnhancer.class$("org.jpox.enhancer.ClassEnhancer")) : class$org$jpox$enhancer$ClassEnhancer).getClassLoader());
    private PMFContext pmfContext;
    private static String jpoxVersion;
    private static String jpoxVendor;
    public static final String ENHANCER_OPTION_CHECKONLY = "org.jpox.enhancer.checkOnly";
    public static final String ENHANCER_OPTION_VERBOSE = "org.jpox.enhancer.verbose";
    public static final String ENHANCER_OPTION_VERIFY = "org.jpox.enhancer.verify";
    public static final String ENHANCER_OPTION_DESTINATION = "org.jpox.enhancer.destination";
    private String api = "JDO";
    private String enhancerName = "BCEL";
    private boolean checkonly = false;
    private boolean verbose = false;
    private boolean verify = false;
    private String[] defaultArgs = new String[0];
    private String destination;
    private ClassLoaderResolver clr;
    static /* synthetic */ Class class$org$jpox$enhancer$ClassEnhancer;
    static /* synthetic */ Class class$org$jpox$metadata$ClassMetaData;
    static /* synthetic */ Class class$org$jpox$ClassLoaderResolver;

    public JPOXEnhancer() {
        this.jpoxSupportInit();
        this.pmfContext = new PMFContext((PMFConfiguration)this);
        this.clr = this.pmfContext.getClassLoaderResolver(null);
    }

    private void jpoxSupportInit() {
        HashMap<String, String> supportOption = new HashMap<String, String>();
        supportOption.put("option.DatastoreIdentity", "true");
        supportOption.put("option.ApplicationIdentity", "true");
        supportOption.put("option.NonDurableIdentity", "true");
        supportOption.put("option.TransientTransactional", "true");
        supportOption.put("required.Serializable", "true");
        supportOption.put("FT_Locale", "true");
        supportOption.put("FT_BigDecimal", "true");
        supportOption.put("FT_BigInteger", "true");
        supportOption.put("FT_Date", "true");
        supportOption.put("FT_HashSet", "true");
        supportOption.put("FT_PersistenceCapable", "true");
        supportOption.put("FT_Collection", "true");
        supportOption.put("FT_Set", "true");
        supportOption.put("FT_Object", "true");
        supportOption.put("FT_ArrayList", "true");
        supportOption.put("FT_HashMap", "true");
        supportOption.put("FT_Hashtable", "true");
        supportOption.put("FT_LinkedList", "true");
        supportOption.put("FT_TreeMap", "true");
        supportOption.put("FT_TreeSet", "true");
        supportOption.put("FT_Vector", "true");
        supportOption.put("FT_Map", "true");
        supportOption.put("FT_List", "true");
        supportOption.put("FT_Arrays", "true");
        EnhancerMetaDataHelper.getInstance().setSupportOption("jpox", supportOption);
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public void setCommandLineArgs(String[] args) {
        CommandLine cmd = new CommandLine();
        cmd.addOption("d", "dest", "<directory>", "output directory");
        cmd.addOption("api", "api", "<adapter-name>", "API Adapter (JDO, JPA, etc)");
        cmd.addOption("enhancerName", "enhancerName", "<enhancer-name>", "Class Enhancer name (BCEL, etc)");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("verify", "verify", null, "verify the enhancement");
        cmd.addOption("checkonly", "checkonly", null, "only check if the class is enhanced");
        cmd.addOption("check", "check", null, "after enhancement, check if the class was enhanced");
        cmd.parse(args);
        if (cmd.hasOption("api")) {
            this.api = cmd.getOptionArg("api");
            this.pmfContext.setApi(this.api);
        }
        if (cmd.hasOption("enhancerName")) {
            this.setEnhancerName(cmd.getOptionArg("enhancerName"));
        }
        if (cmd.hasOption("d")) {
            this.destination = cmd.getOptionArg("d");
            File tmp = new File(this.destination);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    System.out.println(this.destination + " is not directory. please set directory.");
                    System.exit(1);
                }
            } else {
                tmp.mkdirs();
            }
        }
        this.defaultArgs = cmd.getDefaultArgs();
        HashMap<String, String> map = new HashMap<String, String>();
        if (cmd.hasOption("verify")) {
            map.put(ENHANCER_OPTION_VERIFY, Boolean.TRUE.toString());
        }
        if (cmd.hasOption("v")) {
            map.put(ENHANCER_OPTION_VERBOSE, Boolean.TRUE.toString());
        }
        if (cmd.hasOption("checkonly")) {
            map.put(ENHANCER_OPTION_CHECKONLY, Boolean.TRUE.toString());
        }
        this.setOptions(map);
    }

    public String[] getDefaultArgs() {
        return this.defaultArgs;
    }

    public boolean isCheckonly() {
        return this.checkonly;
    }

    public void setCheckonly(boolean checkonly) {
        this.checkonly = checkonly;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getEnhancerName() {
        return this.enhancerName;
    }

    public void setEnhancerName(String enhancer) {
        if (this.enhancerName == null) {
            return;
        }
        this.enhancerName = enhancer;
    }

    public ClassEnhancer getClassEnhancer(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        try {
            Object[] args = new Object[]{cmd, clr};
            Class[] argTypes = new Class[]{class$org$jpox$metadata$ClassMetaData == null ? (class$org$jpox$metadata$ClassMetaData = JPOXEnhancer.class$("org.jpox.metadata.ClassMetaData")) : class$org$jpox$metadata$ClassMetaData, class$org$jpox$ClassLoaderResolver == null ? (class$org$jpox$ClassLoaderResolver = JPOXEnhancer.class$("org.jpox.ClassLoaderResolver")) : class$org$jpox$ClassLoaderResolver};
            return (ClassEnhancer)this.pmfContext.getPluginManager().createExecutableExtension("org.jpox.enhancer.enhancer", "name", this.enhancerName, "class-name", argTypes, args);
        }
        catch (Exception e) {
            throw new RuntimeException(LOCALISER.msg("Enhancer.ClassEnhancerConstructionFailure", (Object)this.enhancerName, (Object)e));
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public PMFContext getPmfContext() {
        return this.pmfContext;
    }

    protected Map initPropertySetters() {
        Map map = super.initPropertySetters();
        map.put(ENHANCER_OPTION_CHECKONLY, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((JPOXEnhancer)configuration).setCheckonly(Boolean.valueOf(s));
            }
        });
        map.put(ENHANCER_OPTION_VERIFY, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((JPOXEnhancer)configuration).setVerify(Boolean.valueOf(s));
            }
        });
        map.put(ENHANCER_OPTION_DESTINATION, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((JPOXEnhancer)configuration).setDestination(s);
            }
        });
        map.put(ENHANCER_OPTION_VERBOSE, new PMFConfiguration.StringPropertySetter(){

            public void set(PMFConfiguration configuration, String s) {
                ((JPOXEnhancer)configuration).setVerbose(Boolean.valueOf(s));
            }
        });
        return map;
    }

    public static void main(String[] args) throws Exception {
        String[] inputfiles;
        JPOXEnhancer enhancer = new JPOXEnhancer();
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver();
        enhancer.setCommandLineArgs(args);
        String msg = null;
        msg = !enhancer.isVerify() && !enhancer.isCheckonly() ? LOCALISER.msg("Enhancer.Title.Enhance", (Object)JPOXEnhancer.getVersionNumber()) : (enhancer.isCheckonly() ? LOCALISER.msg("Enhancer.Title.CheckOnly", (Object)JPOXEnhancer.getVersionNumber()) : LOCALISER.msg("Enhancer.Title.Verify", (Object)JPOXEnhancer.getVersionNumber()));
        JPOXLogger.ENHANCER.info((Object)msg);
        System.out.println(msg);
        System.out.println();
        if (enhancer.isVerbose()) {
            msg = LOCALISER.msg("Enhancer.Classpath");
            JPOXLogger.ENHANCER.info((Object)msg);
            System.out.println(msg);
            StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
            while (tokeniser.hasMoreTokens()) {
                String entry = LOCALISER.msg("Enhancer.Classpath.Entry", (Object)tokeniser.nextToken());
                JPOXLogger.ENHANCER.info((Object)entry);
                System.out.println(entry);
            }
            System.out.println();
        }
        if (enhancer.isVerbose()) {
            msg = LOCALISER.msg("Enhancer.InputFiles");
            JPOXLogger.ENHANCER.info((Object)msg);
            System.out.println(msg);
        }
        if ((inputfiles = enhancer.getDefaultArgs()) != null) {
            if (enhancer.isVerbose()) {
                for (int i = 0; i < inputfiles.length; ++i) {
                    String entry = LOCALISER.msg("Enhancer.InputFiles.Entry", (Object)inputfiles[i]);
                    JPOXLogger.ENHANCER.info((Object)entry);
                    System.out.println(entry);
                }
            }
        } else {
            msg = LOCALISER.msg("Enhancer.NoInputFilesError");
            JPOXLogger.ENHANCER.error((Object)msg);
            System.err.println(msg);
            throw new Exception(msg);
        }
        if (enhancer.isVerbose()) {
            System.out.println();
        }
        if (enhancer.isVerbose()) {
            msg = LOCALISER.msg("Enhancer.ClassEnhancer", (Object)enhancer.getEnhancerName());
            JPOXLogger.ENHANCER.info((Object)msg);
            System.out.println(msg);
            System.out.println();
        }
        FileMetaData[] filemds = null;
        try {
            if (enhancer.getEnhancerName().equals("BCEL")) {
                org.apache.bcel.Repository.setRepository((Repository)new JPOXRepository((ClassLoaderResolver)new JDOClassLoaderResolver()));
                filemds = BCELUtils.getMetaDataForInput(enhancer.getPmfContext(), inputfiles, enhancer.isVerbose());
            }
        }
        catch (Exception e) {
            msg = LOCALISER.msg("Enhancer.ErrorReadingInputFiles", (Object)e.getMessage());
            JPOXLogger.ENHANCER.error((Object)msg, (Throwable)e);
            System.err.println(msg);
            throw e;
        }
        if (filemds == null) {
            msg = LOCALISER.msg("Enhancer.NoValidInputFilesError");
            JPOXLogger.ENHANCER.error((Object)msg);
            System.err.println(msg);
            throw new Exception(msg);
        }
        boolean success = true;
        int noOfClasses = 0;
        for (int filenum = 0; filenum < filemds.length; ++filenum) {
            FileMetaData filemd = filemds[filenum];
            for (int packagenum = 0; packagenum < filemd.getNoOfPackages(); ++packagenum) {
                PackageMetaData pmd = filemd.getPackage(packagenum);
                for (int classnum = 0; classnum < pmd.getNoOfClasses(); ++classnum) {
                    ClassMetaData cmd = pmd.getClass(classnum);
                    ++noOfClasses;
                    try {
                        msg = LOCALISER.msg("Enhancer.ProcessingClass", (Object)cmd.getFullClassName());
                        JPOXLogger.ENHANCER.info((Object)msg);
                        if (enhancer.isVerbose()) {
                            System.out.println(msg);
                        }
                        ClassEnhancer classEnhancer = enhancer.getClassEnhancer((AbstractClassMetaData)cmd, (ClassLoaderResolver)clr);
                        if (enhancer.isCheckonly()) {
                            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                                boolean enhanced = classEnhancer.checkEnhanced();
                                if (!enhancer.isVerbose()) continue;
                                if (enhanced) {
                                    System.out.println("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName());
                                    continue;
                                }
                                System.out.println("NOT ENHANCED (PersistenceCapable) : " + cmd.getFullClassName());
                                continue;
                            }
                            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                                if (!enhancer.isVerbose()) continue;
                                System.out.println("UNKNOWN (PersistenceAware) : " + cmd.getFullClassName());
                                continue;
                            }
                            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.NON_PERSISTENT || !enhancer.isVerbose()) continue;
                            System.out.println("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName());
                            continue;
                        }
                        if (enhancer.isVerify()) {
                            classEnhancer.verify();
                            continue;
                        }
                        classEnhancer.enhance();
                        if (enhancer.getDestination() == null) {
                            classEnhancer.update();
                        } else {
                            classEnhancer.store(enhancer.getDestination());
                        }
                        if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                            boolean enhanced = classEnhancer.checkEnhanced();
                            if (!enhancer.isVerbose()) continue;
                            if (enhanced) {
                                System.out.println("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName());
                                continue;
                            }
                            System.out.println("NOT ENHANCED (PersistenceCapable) : " + cmd.getFullClassName());
                            continue;
                        }
                        if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                            if (!enhancer.isVerbose()) continue;
                            System.out.println("UNKNOWN (PersistenceAware) : " + cmd.getFullClassName());
                            continue;
                        }
                        if (cmd.getPersistenceModifier() != ClassPersistenceModifier.NON_PERSISTENT || !enhancer.isVerbose()) continue;
                        System.out.println("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName());
                        continue;
                    }
                    catch (Exception ex) {
                        String ex_msg = LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)cmd.getFullClassName(), (Object)ex);
                        JPOXLogger.ENHANCER.error((Object)ex_msg);
                        System.err.println(ex_msg);
                        JPOXLogger.ENHANCER.error((Object)ex);
                        success = false;
                    }
                }
            }
        }
        if (success) {
            System.out.println(LOCALISER.msg("Enhancer.Success", noOfClasses));
        }
    }

    public static String getVersionNumber() {
        if (jpoxVersion != null) {
            return jpoxVersion;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.enhancer.Version");
            try {
                version = bundle.getString("jpox.enhancer.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVersion = version;
        return jpoxVersion;
    }

    public static String getVendorName() {
        if (jpoxVendor != null) {
            return jpoxVendor;
        }
        String vendor = "JPOX";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.jpox.enhancer.Version");
            try {
                vendor = bundle.getString("jpox.enhancer.vendor");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        jpoxVendor = vendor;
        return jpoxVendor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

