/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jdo.JDOFatalException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.VerifierFactoryObserver;
import org.jpox.ClassLoaderResolver;
import org.jpox.enhancer.AbstractClassEnhancer;
import org.jpox.enhancer.ClassEnhancer;
import org.jpox.enhancer.bcel.BCELUtils;
import org.jpox.enhancer.bcel.JPOXRepository;
import org.jpox.enhancer.bcel.metadata.BCELClassMetaData;
import org.jpox.enhancer.bcel.metadata.BCELFieldMetaData;
import org.jpox.enhancer.bcel.method.CheckReadMethod;
import org.jpox.enhancer.bcel.method.CheckWriteMethod;
import org.jpox.enhancer.bcel.method.DefaultConstructor;
import org.jpox.enhancer.bcel.method.InitFieldFlags;
import org.jpox.enhancer.bcel.method.InitFieldNames;
import org.jpox.enhancer.bcel.method.InitFieldTypes;
import org.jpox.enhancer.bcel.method.InitPersistenceCapableSuperClass;
import org.jpox.enhancer.bcel.method.JdoCopyField;
import org.jpox.enhancer.bcel.method.JdoCopyFields;
import org.jpox.enhancer.bcel.method.JdoCopyKeyFieldsFromObjectId;
import org.jpox.enhancer.bcel.method.JdoCopyKeyFieldsFromObjectId2;
import org.jpox.enhancer.bcel.method.JdoCopyKeyFieldsToObjectId;
import org.jpox.enhancer.bcel.method.JdoCopyKeyFieldsToObjectId2;
import org.jpox.enhancer.bcel.method.JdoGetManagedFieldCount;
import org.jpox.enhancer.bcel.method.JdoGetObjectId;
import org.jpox.enhancer.bcel.method.JdoGetPersistenceManager;
import org.jpox.enhancer.bcel.method.JdoGetTransactionalObjectId;
import org.jpox.enhancer.bcel.method.JdoGetVersion;
import org.jpox.enhancer.bcel.method.JdoIsDeleted;
import org.jpox.enhancer.bcel.method.JdoIsDetached;
import org.jpox.enhancer.bcel.method.JdoIsDetachedInternal;
import org.jpox.enhancer.bcel.method.JdoIsDirty;
import org.jpox.enhancer.bcel.method.JdoIsNew;
import org.jpox.enhancer.bcel.method.JdoIsPersistent;
import org.jpox.enhancer.bcel.method.JdoIsTransactional;
import org.jpox.enhancer.bcel.method.JdoMakeDirty;
import org.jpox.enhancer.bcel.method.JdoNewInstance1;
import org.jpox.enhancer.bcel.method.JdoNewInstance2;
import org.jpox.enhancer.bcel.method.JdoNewObjectIdInstance1;
import org.jpox.enhancer.bcel.method.JdoNewObjectIdInstance2;
import org.jpox.enhancer.bcel.method.JdoPreSerialize;
import org.jpox.enhancer.bcel.method.JdoProvideField;
import org.jpox.enhancer.bcel.method.JdoProvideFields;
import org.jpox.enhancer.bcel.method.JdoReplaceDetachedState;
import org.jpox.enhancer.bcel.method.JdoReplaceField;
import org.jpox.enhancer.bcel.method.JdoReplaceFields;
import org.jpox.enhancer.bcel.method.JdoReplaceFlags;
import org.jpox.enhancer.bcel.method.JdoReplaceStateManager;
import org.jpox.enhancer.bcel.method.LoadClass;
import org.jpox.enhancer.bcel.method.MediateReadMethod;
import org.jpox.enhancer.bcel.method.MediateWriteMethod;
import org.jpox.enhancer.bcel.method.MethodBuilder;
import org.jpox.enhancer.bcel.method.NormalGetMethod;
import org.jpox.enhancer.bcel.method.NormalSetMethod;
import org.jpox.enhancer.bcel.method.ParentManagedFieldNum;
import org.jpox.enhancer.bcel.method.SuperClone;
import org.jpox.enhancer.bcel.method.WriteObject;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class BCELClassEnhancer
extends AbstractClassEnhancer {
    public final JavaClass oldClass;
    public final ClassGen newClass;
    public final ConstantPoolGen constantPoolGen;
    public final BCELClassMetaData classConfig;
    public final ObjectType classType;
    protected List addFieldList = new ArrayList();
    protected List methodBuilderList = new ArrayList();
    protected long addSerialVersionUID;
    public static final Type OT_Flag = Type.BYTE;
    public static final Type OT_ObjectArray = new ArrayType((Type)Type.OBJECT, 1);
    public static final ObjectType OT_LongIdentity = new ObjectType(CN_LongIdentity);
    public static final ObjectType OT_StringIdentity = new ObjectType(CN_StringIdentity);
    public static final ObjectType OT_ShortIdentity = new ObjectType(CN_ShortIdentity);
    public static final ObjectType OT_IntIdentity = new ObjectType(CN_IntIdentity);
    public static final ObjectType OT_CharIdentity = new ObjectType(CN_CharIdentity);
    public static final ObjectType OT_ByteIdentity = new ObjectType(CN_ByteIdentity);
    public static final ObjectType OT_ObjectIdentity = new ObjectType(CN_ObjectIdentity);
    public static final ObjectType OT_PersistenceManager = new ObjectType(CN_PersistenceManager);
    public static final ObjectType OT_ObjectIdFieldConsumer = new ObjectType(CN_ObjectIdFieldConsumer);
    public static final ObjectType OT_ObjectIdFieldSupplier = new ObjectType(CN_ObjectIdFieldSupplier);
    public static final ObjectType OT_BitSet = new ObjectType(CN_BitSet);
    public static final ObjectType OT_StateManager = new ObjectType(CN_StateManager);
    public static final ObjectType OT_PersistenceCapable = new ObjectType(CN_PersistenceCapable);
    public static final ObjectType OT_Detachable = new ObjectType(CN_Detachable);
    public static final ObjectType OT_JDOImplHelper = new ObjectType(CN_JDOImplHelper);
    public static final ObjectType OT_CLASS = new ObjectType(CN_Class);
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Class;

    public BCELClassEnhancer(ClassMetaData cmd, ClassLoaderResolver clr) {
        super(cmd, clr);
        BCELClassMetaData bcelClassConfig;
        if (!(cmd instanceof BCELClassMetaData)) {
            throw new RuntimeException("MetaData for class " + cmd.getFullClassName() + " is not BCEL-specific and so cannot be used");
        }
        this.classConfig = bcelClassConfig = (BCELClassMetaData)cmd;
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.SetupClass", (Object)this.className));
        }
        this.oldClass = bcelClassConfig.getEnhanceClass();
        this.newClass = bcelClassConfig.getClassGen();
        this.constantPoolGen = this.newClass.getConstantPool();
        this.classType = new ObjectType(this.className);
        ArrayList<Field> tmpList = new ArrayList<Field>();
        for (int i = 0; i < cmd.getNoOfFields(); ++i) {
            BCELFieldMetaData fmd = (BCELFieldMetaData)cmd.getField(i);
            if (fmd.isFinal() || fmd.isStatic()) continue;
            String fieldName = fmd.getName();
            Field field = BCELUtils.getFieldByName(fieldName, this.newClass);
            if (field == null) {
                throw new RuntimeException(LOCALISER.msg("Enhancer.ClassHasNoSuchField", (Object)this.newClass.getClassName(), (Object)fieldName));
            }
            tmpList.add(field);
        }
    }

    public void init() {
        this.init_addFieldsList();
        this.init_addMethodCallbackList();
    }

    protected void init_addMethodCallbackList() {
        boolean hasPcsc;
        boolean isDetachable = this.cmd.isDetachable();
        boolean bl = hasPcsc = this.cmd.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc) {
            this.methodBuilderList.add(JdoCopyKeyFieldsFromObjectId.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsFromObjectId2.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsToObjectId.getInstance(this));
            this.methodBuilderList.add(JdoCopyKeyFieldsToObjectId2.getInstance(this));
            this.methodBuilderList.add(JdoGetObjectId.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoGetVersion.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoPreSerialize.getInstance(this));
            this.methodBuilderList.add(JdoGetPersistenceManager.getInstance(this));
            this.methodBuilderList.add(JdoGetTransactionalObjectId.getInstance(this));
            this.methodBuilderList.add(JdoIsDeleted.getInstance(this));
            this.methodBuilderList.add(JdoIsDirty.getInstance(this, isDetachable));
            this.methodBuilderList.add(JdoIsNew.getInstance(this));
            this.methodBuilderList.add(JdoIsPersistent.getInstance(this));
            this.methodBuilderList.add(JdoIsTransactional.getInstance(this));
            this.methodBuilderList.add(JdoIsDetached.getInstance(this));
            this.methodBuilderList.add(JdoMakeDirty.getInstance(this));
            this.methodBuilderList.add(JdoNewObjectIdInstance1.getInstance(this));
            this.methodBuilderList.add(JdoNewObjectIdInstance2.getInstance(this));
            this.methodBuilderList.add(JdoProvideFields.getInstance(this));
            this.methodBuilderList.add(JdoReplaceFields.getInstance(this));
            this.methodBuilderList.add(JdoReplaceFlags.getInstance(this));
            this.methodBuilderList.add(JdoReplaceStateManager.getInstance(this));
        }
        if (this.requiresDetachable()) {
            this.methodBuilderList.add(JdoReplaceDetachedState.getInstance(this));
        }
        this.methodBuilderList.add(JdoIsDetachedInternal.getInstance(this, isDetachable));
        this.methodBuilderList.add(JdoNewInstance1.getInstance(this));
        this.methodBuilderList.add(JdoNewInstance2.getInstance(this));
        this.methodBuilderList.add(JdoReplaceField.getInstance(this));
        this.methodBuilderList.add(JdoProvideField.getInstance(this));
        this.methodBuilderList.add(JdoCopyField.getInstance(this));
        this.methodBuilderList.add(JdoCopyFields.getInstance(this));
        this.methodBuilderList.add(InitFieldNames.getInstance(this));
        this.methodBuilderList.add(InitFieldTypes.getInstance(this));
        this.methodBuilderList.add(InitFieldFlags.getInstance(this));
        this.methodBuilderList.add(ParentManagedFieldNum.getInstance(this));
        this.methodBuilderList.add(JdoGetManagedFieldCount.getInstance(this));
        this.methodBuilderList.add(InitPersistenceCapableSuperClass.getInstance(this));
        this.methodBuilderList.add(LoadClass.getInstance(this));
        this.methodBuilderList.add(SuperClone.getInstance(this));
        if (this.checkHasDefaultConstructor() != null) {
            this.methodBuilderList.add(DefaultConstructor.getInstance(this));
        }
        try {
            if (BCELUtils.isInstanceof(this.oldClass, class$java$io$Serializable == null ? (class$java$io$Serializable = BCELClassEnhancer.class$("java.io.Serializable")) : class$java$io$Serializable) && BCELUtils.findMethod(this.newClass, "writeObject", "(Ljava/io/ObjectOutputStream;)V") == null) {
                this.methodBuilderList.add(WriteObject.getInstance(this));
                if (BCELUtils.getFieldByName("serialVersionUID", this.newClass) == null) {
                    this.addFieldList.add(new FieldGen(26, (Type)Type.LONG, "serialVersionUID", this.constantPoolGen));
                    Class<?> oClass = Class.forName(this.cmd.getFullClassName(), false, this.getClass().getClassLoader());
                    this.addSerialVersionUID = ObjectStreamClass.lookup(oClass).getSerialVersionUID();
                }
            }
        }
        catch (ClassNotFoundException e) {
            JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)this.cmd.getFullClassName(), (Object)e));
        }
    }

    protected void init_addFieldsList() {
        boolean hasPcsc;
        boolean bl = hasPcsc = this.cmd.getPersistenceCapableSuperclass() != null;
        if (!hasPcsc) {
            this.addFieldList.add(new FieldGen(132, (Type)OT_StateManager, "jdoStateManager", this.constantPoolGen));
            this.addFieldList.add(new FieldGen(132, OT_Flag, "jdoFlags", this.constantPoolGen));
        }
        if (this.requiresDetachable()) {
            this.addFieldList.add(new FieldGen(4, OT_ObjectArray, "jdoDetachedState", this.constantPoolGen));
        }
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((Type)Type.BYTE, 1), "jdoFieldFlags", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)OT_CLASS, "jdoPersistenceCapableSuperclass", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((class$java$lang$Class == null ? (class$java$lang$Class = BCELClassEnhancer.class$("java.lang.Class")) : class$java$lang$Class).getName(), 1), "jdoFieldTypes", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)new ArrayType((Type)Type.STRING, 1), "jdoFieldNames", this.constantPoolGen));
        this.addFieldList.add(new FieldGen(26, (Type)Type.INT, "jdoInheritedFieldCount", this.constantPoolGen));
    }

    public String check() {
        if (ClassUtils.isInnerClass((String)this.className) && (this.getAccessFlagsForInnerClass(this.oldClass, this.className) & 8) == 0) {
            return LOCALISER.msg("Enhancer.PersistentInnerClassMustBeStatic", (Object)this.newClass.getClassName());
        }
        return null;
    }

    private int getAccessFlagsForInnerClass(JavaClass javaClass, String className) {
        for (int i = 0; i < javaClass.getAttributes().length; ++i) {
            if (!(javaClass.getAttributes()[i] instanceof InnerClasses)) continue;
            InnerClasses innerClasses = (InnerClasses)javaClass.getAttributes()[i];
            for (int j = 0; j < innerClasses.getInnerClasses().length; ++j) {
                String name = this.constantPoolGen.getConstantPool().getConstantString(innerClasses.getInnerClasses()[j].getInnerClassIndex(), (byte)7);
                if (!name.equals(className)) continue;
                return innerClasses.getInnerClasses()[i].getInnerAccessFlags();
            }
        }
        return -1;
    }

    protected String checkHasDefaultConstructor() {
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<init>") || !methods[i].getSignature().equals("()V")) continue;
            return null;
        }
        return LOCALISER.msg("Enhancer.RequiresDefaultConstructor", (Object)this.newClass.getClassName());
    }

    public boolean checkEnhanced() {
        Method[] methods;
        String[] interfaceNames = this.newClass.getInterfaceNames();
        if (interfaceNames != null) {
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (!interfaceNames[i].equals(CN_PersistenceCapable)) continue;
                return true;
            }
        }
        if ((methods = this.newClass.getMethods()) != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("jdoReplaceField")) continue;
                return true;
            }
        }
        return false;
    }

    public void enhance() {
        this.init();
        if (this.checkEnhanced()) {
            JPOXLogger.JDO.info((Object)LOCALISER.msg("Enhancer.ClassIsAlreadyEnhanced", (Object)this.newClass.getClassName()));
            return;
        }
        String message = this.check();
        if (message != null) {
            JPOXLogger.ENHANCER.error((Object)message);
            return;
        }
        if (this.cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.enhanceOriginalMethods();
            this.enhanceClassBefore();
            this.enhanceClass();
            this.enhanceClassAfter();
            this.enhanceFieldsBefore();
            this.enhanceFields();
            this.enhanceFieldsAfter();
            this.enhanceMethodBefore();
            this.enhanceMethod();
            this.enhanceMethodAfter();
            this.enhanceStaticInitializerBefore();
            this.enhanceStaticInitializer();
            this.enhanceStaticInitializerAfter();
        } else if (this.cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
            this.enhanceOriginalMethods();
        }
        this.update = true;
    }

    public void enhanceClass() {
        if (this.cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            this.class_addInterface(ClassEnhancer.CN_PersistenceCapable);
            if (this.requiresDetachable()) {
                this.class_addInterface(ClassEnhancer.CN_Detachable);
            }
            for (int i = 0; i < this.cmd.getNoOfFields(); ++i) {
                BCELFieldMetaData f = (BCELFieldMetaData)this.cmd.getField(i);
                if (!f.fieldBelongsToClass() || BCELUtils.isSynthetic((FieldOrMethod)f.getEnhanceField())) continue;
                this.enhanceSetter(f);
                this.enhanceGetter(f);
            }
        }
    }

    protected void class_addInterface(String interfaceName) {
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.AddInterface", (Object)interfaceName));
        }
        this.newClass.addInterface(interfaceName);
        this.newClass.update();
    }

    public void enhanceClassAfter() {
    }

    public void enhanceClassBefore() {
    }

    public void enhanceFields() {
        for (int i = 0; i < this.addFieldList.size(); ++i) {
            FieldGen gen = (FieldGen)this.addFieldList.get(i);
            this.field_addField(gen);
        }
    }

    protected void field_addField(FieldGen fieldGen) {
        Field f = fieldGen.getField();
        this.newClass.addField(f);
        BCELUtils.addSynthetic((FieldOrMethod)f, this.constantPoolGen);
        if (JPOXLogger.ENHANCER.isDebugEnabled()) {
            JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.AddField", (Object)f.getType(), (Object)f.getName()));
        }
        this.newClass.update();
    }

    public void enhanceFieldsAfter() {
    }

    public void enhanceFieldsBefore() {
    }

    public void enhanceMethod() {
        for (int i = 0; i < this.methodBuilderList.size(); ++i) {
            Object o = this.methodBuilderList.get(i);
            if (o instanceof MethodBuilder) {
                MethodBuilder callback = (MethodBuilder)o;
                callback.init();
                callback.execute();
                callback.close();
                continue;
            }
            if (o == null) {
                JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.CallbackIsNullError"));
                continue;
            }
            JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.CallbackIsNotMethodBuilderError", (Object)o.getClass().getName()));
        }
    }

    public void enhanceMethodAfter() {
    }

    public void enhanceMethodBefore() {
    }

    public void enhanceStaticInitializer() {
        InstructionList il = null;
        InstructionFactory factory = new InstructionFactory(this.newClass);
        Method clinit = null;
        InstructionList ilOriginal = null;
        MethodGen methodGen = null;
        MethodGen methodGenOriginal = null;
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<clinit>")) continue;
            clinit = methods[i];
            methodGenOriginal = new MethodGen(clinit, this.className, this.constantPoolGen);
            ilOriginal = methodGenOriginal.getInstructionList();
            break;
        }
        il = new InstructionList();
        methodGen = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, null, "<clinit>", this.className, il, this.constantPoolGen);
        if (ilOriginal != null) {
            il.append(ilOriginal);
            InstructionHandle[] h = il.getInstructionHandles();
            if ("return".equalsIgnoreCase(h[h.length - 1].getInstruction().getName())) {
                try {
                    il.delete(h[h.length - 1]);
                }
                catch (TargetLostException e) {
                    InstructionHandle[] targets = e.getTargets();
                    for (int i2 = 0; i2 < targets.length; ++i2) {
                        InstructionTargeter[] targeters = targets[i2].getTargeters();
                        for (int j = 0; j < targeters.length; ++j) {
                            targeters[j].updateTarget(targets[i2], h[j]);
                        }
                    }
                }
            }
        }
        if (this.addSerialVersionUID != 0L) {
            int svUidIndex = this.constantPoolGen.addLong(this.addSerialVersionUID);
            il.append((Instruction)new LDC2_W(svUidIndex));
            il.append((Instruction)factory.createPutStatic(this.className, "serialVersionUID", (Type)Type.LONG));
        }
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldNamesInit", (Type)new ArrayType((Type)Type.STRING, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldNames", (Type)new ArrayType((Type)Type.STRING, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldTypesInit", (Type)new ArrayType((Type)OT_CLASS, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldTypes", (Type)new ArrayType((Type)OT_CLASS, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoFieldFlagsInit", (Type)new ArrayType((Type)Type.BYTE, 1), Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoFieldFlags", (Type)new ArrayType((Type)Type.BYTE, 1)));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoGetInheritedFieldCount", (Type)Type.INT, Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoInheritedFieldCount", (Type)Type.INT));
        il.append((Instruction)factory.createInvoke(this.className, "__jdoPersistenceCapableSuperclassInit", (Type)OT_CLASS, Type.NO_ARGS, (short)184));
        il.append((Instruction)factory.createPutStatic(this.className, "jdoPersistenceCapableSuperclass", (Type)OT_CLASS));
        il.append((Instruction)new LDC(this.constantPoolGen.addString(this.className)));
        il.append((Instruction)factory.createInvoke(this.className, "___jdo$loadClass", (Type)OT_CLASS, new Type[]{Type.STRING}, (short)184));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldNames", (Type)new ArrayType((Type)Type.STRING, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldTypes", (Type)new ArrayType((Type)OT_CLASS, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoFieldFlags", (Type)new ArrayType((Type)Type.BYTE, 1)));
        il.append((Instruction)factory.createGetStatic(this.className, "jdoPersistenceCapableSuperclass", (Type)OT_CLASS));
        if (this.classConfig.getClassGen().isAbstract()) {
            il.append(InstructionConstants.ACONST_NULL);
        } else {
            il.append((Instruction)factory.createNew(new ObjectType(this.className)));
            il.append((Instruction)InstructionConstants.DUP);
            il.append((Instruction)factory.createInvoke(this.className, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        }
        il.append((Instruction)factory.createInvoke(CN_JDOImplHelper, "registerClass", (Type)Type.VOID, new Type[]{OT_CLASS, new ArrayType((Type)Type.STRING, 1), new ArrayType((Type)OT_CLASS, 1), new ArrayType((Type)Type.BYTE, 1), OT_CLASS, OT_PersistenceCapable}, (short)184));
        this.staticInitializerAppend(factory, il);
        il.append((Instruction)InstructionConstants.RETURN);
        if (clinit != null) {
            this.newClass.removeMethod(clinit);
        }
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        Method method = methodGen.getMethod();
        Method[] allMethod = this.newClass.getMethods();
        this.newClass.replaceMethod(allMethod[0], method);
        this.newClass.addMethod(allMethod[0]);
        il.dispose();
    }

    protected void staticInitializerAppend(InstructionFactory factory, InstructionList il) {
    }

    public void enhanceStaticInitializerAfter() {
    }

    public void enhanceStaticInitializerBefore() {
    }

    protected void enhanceOriginalMethod(Method m) {
        boolean isDebugEnabled = JPOXLogger.ENHANCER.isDebugEnabled();
        if (BCELUtils.isSynthetic((FieldOrMethod)m)) {
            return;
        }
        MethodGen methodGen = new MethodGen(m, this.className, this.constantPoolGen);
        InstructionList il = methodGen.getInstructionList();
        if (il == null || il.size() == 0) {
            return;
        }
        InstructionFactory factory = new InstructionFactory(this.newClass);
        boolean isCloneMethod = "clone".equals(m.getName()) && (m.getArgumentTypes() == null || m.getArgumentTypes().length == 0);
        boolean change = false;
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof GETFIELD || i instanceof PUTFIELD) {
                FieldInstruction field = (FieldInstruction)i;
                Constant c = m.getConstantPool().getConstant(field.getIndex());
                ConstantFieldref fieldRef = (ConstantFieldref)c;
                ConstantClass cclass = (ConstantClass)m.getConstantPool().getConstant(fieldRef.getClassIndex());
                ConstantUtf8 utfClassName = (ConstantUtf8)m.getConstantPool().getConstant(cclass.getNameIndex());
                JavaClass fieldJavaClass = null;
                try {
                    fieldJavaClass = Repository.lookupClass((String)StringUtils.replaceAll((String)utfClassName.getBytes().toString(), (String)"/", (String)"."));
                }
                catch (Throwable ex) {
                    JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
                    throw new JDOFatalException(LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
                }
                Field f = BCELUtils.getFieldByName(field.getName(this.constantPoolGen), fieldJavaClass);
                if (f == null) {
                    String message = LOCALISER.msg("Enhancer.FieldIsNull", (Object)this.className, (Object)m.getName(), (Object)field.getName(this.constantPoolGen));
                    JPOXLogger.ENHANCER.error((Object)message);
                    throw new NullPointerException(message);
                }
                ClassGen cg = BCELUtils.getClassByFieldByName(field.getName(this.constantPoolGen), fieldJavaClass);
                BCELFieldMetaData fieldConfig = null;
                BCELClassMetaData jdoConfigClass = this.classConfig;
                if (!this.isPersistenceCapable(StringUtils.replaceAll((String)cg.getClassName(), (String)"/", (String)"."))) continue;
                if (!cg.getClassName().equals(this.newClass.getClassName())) {
                    jdoConfigClass = (BCELClassMetaData)this.classConfig.getPackageMetaData().getFileMetaData().getMetaDataManager().getMetaDataForClass(cg.getClassName(), this.clr);
                }
                if ((fieldConfig = jdoConfigClass.findField(f)) == null) {
                    String message = LOCALISER.msg("Enhancer.FieldConfigIsNullError", (Object)(this.className + "." + f.getName()));
                    JPOXLogger.ENHANCER.fatal((Object)message);
                    throw new RuntimeException(message);
                }
                if (!this.isFieldAccessInPersistenceCapableClass(ih, m.getConstantPool()) || fieldConfig != null && fieldConfig.getJdoFieldFlag() == 0 || f.isStatic() || f.isFinal() || BCELUtils.isSynthetic((FieldOrMethod)f)) continue;
                if (isDebugEnabled) {
                    JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.EnhanceOriginalMethod", (Object)(this.className + "." + m.getName()), (Object)f.getName()));
                }
                if (i instanceof GETFIELD) {
                    ih.setInstruction((Instruction)factory.createInvoke(cg.getClassName(), "jdo" + BCELUtils.getGetterName(f), field.getType(this.constantPoolGen), new Type[]{new ObjectType(cg.getClassName())}, (short)184));
                } else {
                    ih.setInstruction((Instruction)factory.createInvoke(cg.getClassName(), "jdo" + BCELUtils.getSetterName(f), (Type)Type.VOID, new Type[]{new ObjectType(cg.getClassName()), field.getType(this.constantPoolGen)}, (short)184));
                }
                change = true;
                continue;
            }
            if (!isCloneMethod || !(i instanceof INVOKESPECIAL)) continue;
            INVOKESPECIAL is = (INVOKESPECIAL)i;
            if (this.cmd.getPersistenceCapableSuperclass() != null || !"clone".equals(is.getMethodName(this.constantPoolGen)) || !"()Ljava/lang/Object;".equals(is.getSignature(this.constantPoolGen))) continue;
            ih.setInstruction((Instruction)factory.createInvoke(this.className, "jdoSuperClone", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            if (isDebugEnabled) {
                JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.EnhanceOriginalMethod", (Object)(this.className + "." + m.getName()), (Object)"super.clone()"));
            }
            change = true;
        }
        if (change) {
            methodGen.setMaxLocals();
            methodGen.setMaxStack();
            this.newClass.replaceMethod(m, methodGen.getMethod());
        }
    }

    protected void enhanceOriginalMethods() {
        Method[] methods = this.newClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if ("jdoPreClear".equals(methods[i].getName()) || "jdoPostLoad".equals(methods[i].getName()) || "readObject".equals(methods[i].getName()) && (methods[i].getSignature().equals("(Ljava/io/ObjectOutputStream;)V") || methods[i].getSignature().equals("(Ljava/io/ObjectInputStream;)V"))) continue;
            this.enhanceOriginalMethod(methods[i]);
        }
    }

    private String getClassNameForFieldAccess(InstructionHandle ih, ConstantPool cp) {
        Constant c = cp.getConstant(((CPInstruction)ih.getInstruction()).getIndex());
        if (c instanceof ConstantFieldref) {
            ConstantFieldref fieldRef = (ConstantFieldref)c;
            ConstantClass cclass = (ConstantClass)cp.getConstant(fieldRef.getClassIndex());
            ConstantUtf8 className = (ConstantUtf8)cp.getConstant(cclass.getNameIndex());
            return StringUtils.replaceAll((String)className.getBytes().toString(), (String)"/", (String)".");
        }
        return null;
    }

    private boolean isFieldAccessInPersistenceCapableClass(InstructionHandle ih, ConstantPool cp) {
        String className = this.getClassNameForFieldAccess(ih, cp);
        if (className == null) {
            return false;
        }
        return this.isPersistenceCapable(className);
    }

    protected void enhanceSetter(BCELFieldMetaData fieldConfig) {
        Field f = fieldConfig.getEnhanceField();
        String methodName = BCELUtils.getSetterName(fieldConfig.getEnhanceField());
        MethodBuilder callback = null;
        byte jdoFlag = fieldConfig.getJdoFieldFlag();
        if (f.isFinal() || f.isStatic()) {
            return;
        }
        if (FieldPersistenceModifier.NONE.equals((Object)fieldConfig.getPersistenceModifier())) {
            return;
        }
        callback = (jdoFlag & 2) == 2 ? new MediateWriteMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_m"}, true, this, fieldConfig) : ((jdoFlag & 1) == 1 ? new CheckWriteMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_c"}, true, this, fieldConfig) : new NormalSetMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, (Type)Type.VOID, new Type[]{this.classType, f.getType()}, new String[]{"objPC", f.getName() + "_n"}, true, this, fieldConfig));
        if (callback != null) {
            this.methodBuilderList.add(callback);
        }
    }

    protected void enhanceGetter(BCELFieldMetaData fieldConfig) {
        Field f = fieldConfig.getEnhanceField();
        String methodName = BCELUtils.getGetterName(f);
        MethodBuilder callback = null;
        byte jdoFlag = fieldConfig.getJdoFieldFlag();
        if (f.isFinal() || f.isStatic()) {
            return;
        }
        if (FieldPersistenceModifier.NONE.equals((Object)fieldConfig.getPersistenceModifier())) {
            return;
        }
        callback = (jdoFlag & 2) == 2 ? new MediateReadMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig) : ((jdoFlag & 1) == 1 ? new CheckReadMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig) : new NormalGetMethod("jdo" + methodName, (f.isPublic() ? 1 : 0) | (f.isProtected() ? 4 : 0) | (f.isPrivate() ? 2 : 0) | 8, f.getType(), new Type[]{this.classType}, new String[]{"objPC"}, true, this, fieldConfig));
        this.methodBuilderList.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException {
        if (!this.update) {
            return;
        }
        URL path = ((JPOXRepository)Repository.getRepository()).getURL(this.className);
        JPOXLogger.ENHANCER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)path));
        File f = null;
        FileOutputStream fOut = null;
        try {
            URL convertedPath = this.cmd.getMetaDataManager().getPMFContext().getPluginManager().resolveURLAsFileURL(path);
            if (!convertedPath.toString().equals(path.toString())) {
                JPOXLogger.ENHANCER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)path));
            }
            f = StringUtils.getFileForFilename((String)convertedPath.getFile());
            fOut = new FileOutputStream(f);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            this.dumpClass(bout);
            bout.flush();
        }
        finally {
            try {
                fOut.close();
                fOut = null;
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String dir) throws IOException {
        if (!this.update) {
            return;
        }
        File baseDir = new File(dir);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        } else if (!baseDir.isDirectory()) {
            throw new RuntimeException("not directory " + dir);
        }
        String sep = System.getProperty("file.separator");
        String name = this.cmd.getFullClassName();
        name = name.replace('.', sep.charAt(0));
        name = name + ".class";
        File f = new File(dir, name);
        f.getParentFile().mkdirs();
        FileOutputStream fOut = null;
        JPOXLogger.ENHANCER.info((Object)LOCALISER.msg("Enhancer.UpdateClass", (Object)f.getCanonicalPath()));
        try {
            fOut = new FileOutputStream(f);
            BufferedOutputStream bout = new BufferedOutputStream(fOut);
            this.dumpClass(bout);
            bout.flush();
        }
        finally {
            try {
                fOut.close();
                fOut = null;
            }
            catch (Exception ignore) {}
        }
    }

    protected void dumpClass(OutputStream out) throws IOException {
        this.newClass.getJavaClass().dump(out);
        out.flush();
    }

    public byte[] getBytes() {
        return this.newClass.getJavaClass().getBytes();
    }

    public void verify() throws Exception {
        VerifierFactory.attach((VerifierFactoryObserver)new VerifierFactoryObserver(){

            public void update(String s) {
            }
        });
        Verifier verifier = VerifierFactory.getVerifier((String)this.className);
        VerificationResult result = verifier.doPass1();
        if (1 != result.getStatus()) {
            JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
            return;
        }
        result = verifier.doPass2();
        if (1 != result.getStatus()) {
            JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
            return;
        }
        Method[] methods = this.classConfig.getClassGen().getMethods();
        JPOXLogger.ENHANCER.info((Object)("methods num:" + methods.length));
        for (int i = 0; i < methods.length; ++i) {
            try {
                result = verifier.doPass3a(i);
                if (1 == result.getStatus()) continue;
                JPOXLogger.ENHANCER.fatal((Object)result.getMessage());
                continue;
            }
            catch (Exception e) {
                JPOXLogger.ENHANCER.error((Object)(i + " " + methods[i].getName()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

