/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.enhancer.AbstractImplementationGenerator;
import org.jpox.enhancer.ImplementationCreatorImpl;
import org.jpox.enhancer.bcel.BCELClassEnhancer;
import org.jpox.enhancer.bcel.metadata.BCELClassMetaData;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.util.ClassUtils;

public class BCELImplementationGenerator
extends AbstractImplementationGenerator
implements Constants {
    private final InstructionFactory factory;
    private final ConstantPoolGen constantPool;
    private final ClassGen classGen;
    private static final String fullSuperClassName = "java.lang.Object";
    private JavaClass javaClass;
    private BCELClassMetaData ecmd;

    public BCELImplementationGenerator(InterfaceMetaData interfaceMetaData) {
        super(interfaceMetaData);
        ArrayList<String> interfaces = new ArrayList<String>();
        InterfaceMetaData imd = interfaceMetaData;
        do {
            interfaces.add(imd.getFullClassName());
        } while ((imd = (InterfaceMetaData)imd.getSuperAbstractClassMetaData()) != null);
        this.classGen = new ClassGen(this.fullClassName, fullSuperClassName, this.className + ".java", 33, interfaces.toArray(new String[interfaces.size()]));
        this.constantPool = this.classGen.getConstantPool();
        this.factory = new InstructionFactory(this.classGen, this.constantPool);
    }

    public void create() {
        this.createFields();
        this.createDefaultConstructor();
        this.createMethods();
        this.javaClass = this.classGen.getJavaClass();
        this.bytes = this.javaClass.getBytes();
        this.ecmd = new BCELClassMetaData(this.interfaceMetaData, this.getClassName(), this.javaClass);
    }

    public void enhance() {
        ImplementationCreatorImpl.ImplementationCreatorClassLoader loader = new ImplementationCreatorImpl.ImplementationCreatorClassLoader();
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver((ClassLoader)loader);
        loader.defineClass(this.getFullClassName(), this.getBytes());
        this.ecmd.populate((ClassLoaderResolver)clr, null);
        this.ecmd.initialise();
        BCELClassEnhancer gen = new BCELClassEnhancer(this.ecmd, (ClassLoaderResolver)clr);
        gen.enhance();
        this.bytes = gen.getBytes();
    }

    public void dump(OutputStream io) throws IOException {
        this.javaClass.dump(io);
    }

    protected void createFields(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return;
        }
        AbstractPropertyMetaData[] propertyMetaData = acmd.getManagedFields();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            FieldGen field = new FieldGen(2, this.getObjectTypeByName(propertyMetaData[i].getTypeName()), propertyMetaData[i].getName(), this.constantPool);
            this.classGen.addField(field.getField());
        }
    }

    protected void createMethods(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return;
        }
        AbstractPropertyMetaData[] propertyMetaData = acmd.getManagedFields();
        for (int i = 0; i < propertyMetaData.length; ++i) {
            boolean isBoolean = propertyMetaData[i].getTypeName().equals("boolean");
            this.createGetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanGetterName((String)propertyMetaData[i].getName(), (boolean)isBoolean), propertyMetaData[i].getName());
            this.createSetter(propertyMetaData[i].getTypeName(), ClassUtils.getJavaBeanSetterName((String)propertyMetaData[i].getName()), propertyMetaData[i].getName());
        }
    }

    protected void createDefaultConstructor() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.factory.createInvoke(fullSuperClassName, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    protected void createGetter(String typeName, String getterName, String fieldName) {
        Type objectType = this.getObjectTypeByName(typeName);
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, objectType, Type.NO_ARGS, new String[0], getterName, this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.factory.createFieldAccess(this.fullClassName, fieldName, objectType, (short)180));
        il.append((Instruction)InstructionFactory.createReturn((Type)objectType));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    protected void createSetter(String typeName, String setterName, String fieldName) {
        Type objectType = this.getObjectTypeByName(typeName);
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, new Type[]{objectType}, new String[]{"arg0"}, setterName, this.fullClassName, il, this.constantPool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)InstructionFactory.createLoad((Type)objectType, (int)1));
        il.append((Instruction)this.factory.createFieldAccess(this.fullClassName, fieldName, objectType, (short)181));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.classGen.addMethod(method.getMethod());
        il.dispose();
    }

    private Type getObjectTypeByName(String typeName) {
        if (typeName.equals("int")) {
            return Type.INT;
        }
        if (typeName.equals("boolean")) {
            return Type.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return Type.BYTE;
        }
        if (typeName.equals("char")) {
            return Type.CHAR;
        }
        if (typeName.equals("double")) {
            return Type.DOUBLE;
        }
        if (typeName.equals("float")) {
            return Type.FLOAT;
        }
        if (typeName.equals("long")) {
            return Type.LONG;
        }
        if (typeName.equals("short")) {
            return Type.SHORT;
        }
        return new ObjectType(typeName);
    }
}

