/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jdo.JDOFatalException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.Type;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFContext;
import org.jpox.enhancer.bcel.metadata.BCELMetaDataManager;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public final class BCELUtils {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.jpox.enhancer.Localisation", (ClassLoader)(class$org$jpox$enhancer$ClassEnhancer == null ? (class$org$jpox$enhancer$ClassEnhancer = BCELUtils.class$("org.jpox.enhancer.ClassEnhancer")) : class$org$jpox$enhancer$ClassEnhancer).getClassLoader());
    static /* synthetic */ Class class$org$jpox$enhancer$ClassEnhancer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    private BCELUtils() {
    }

    public static FileMetaData[] getMetaDataForInput(PMFContext context, String[] fileList, boolean verbose) throws Exception {
        int i;
        ArrayList<FileMetaData> configList = new ArrayList<FileMetaData>();
        if (fileList == null) {
            return null;
        }
        BCELMetaDataManager mgr = new BCELMetaDataManager(context);
        ClassLoaderResolver clr = context.getClassLoaderResolver(null);
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.ReadJDOFilesStart", (Object)("" + fileList.length)));
        for (i = 0; i < fileList.length; ++i) {
            String msg;
            if (fileList[i].endsWith(".class")) continue;
            try {
                FileMetaData conf = mgr.parseAndRegisterFile(fileList[i], clr);
                if (conf == null) {
                    msg = LOCALISER.msg("Enhancer.CannotReadFileErrorUnknownCauseWithoutHelp", (Object)fileList[i]);
                    System.err.println(msg);
                    JPOXLogger.ENHANCER.error((Object)msg);
                    continue;
                }
                configList.add(conf);
                continue;
            }
            catch (Exception ex) {
                msg = LOCALISER.msg("Enhancer.ErrorParsingFile", (Object)fileList[i], (Object)ex);
                System.out.println(msg);
                JPOXLogger.ENHANCER.error((Object)msg);
            }
        }
        for (i = 0; i < fileList.length; ++i) {
            String msg;
            if (!fileList[i].endsWith(".class")) continue;
            if (!StringUtils.getFileForFilename((String)fileList[i]).exists()) {
                System.out.println("File " + fileList[i] + " does not exist.");
                JPOXLogger.ENHANCER.error((Object)("File " + fileList[i] + " does not exist."));
                continue;
            }
            String className = new ClassParser(fileList[i]).parse().getClassName();
            try {
                FileMetaData conf = mgr.parseAndRegisterClass(className, clr);
                if (conf == null) {
                    msg = LOCALISER.msg("Enhancer.ClassHasNoAnnotationsOrMetaData", (Object)fileList[i]);
                    if (verbose) {
                        System.out.println(msg);
                    }
                    JPOXLogger.ENHANCER.info((Object)msg);
                    continue;
                }
                configList.add(conf);
                continue;
            }
            catch (Exception ex) {
                msg = LOCALISER.msg("Enhancer.ErrorParsingFile", (Object)fileList[i], (Object)ex);
                System.out.println(msg);
                JPOXLogger.ENHANCER.error((Object)msg);
            }
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.ReadJDOFilesEnd", (Object)("" + fileList.length), (Object)("" + configList.size())));
        Iterator configIter = configList.iterator();
        while (configIter.hasNext()) {
            FileMetaData filemd = (FileMetaData)configIter.next();
            mgr.populateRegisteredFile(filemd, clr);
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialiseJDOFilesStart", (Object)("" + configList.size())));
        boolean metadataIncorrect = false;
        FileMetaData[] metadata = new FileMetaData[configList.size()];
        for (int i2 = 0; i2 < metadata.length; ++i2) {
            metadata[i2] = (FileMetaData)configList.get(i2);
            for (int j = 0; j < metadata[i2].getNoOfPackages(); ++j) {
                PackageMetaData pmd = metadata[i2].getPackage(j);
                for (int k = 0; k < pmd.getNoOfClasses(); ++k) {
                    ClassMetaData cmd = pmd.getClass(k);
                    try {
                        if (cmd.isInitialised()) continue;
                        mgr.initialiseClassMetaData(cmd, clr);
                        continue;
                    }
                    catch (Exception ex) {
                        metadataIncorrect = true;
                        System.err.println(LOCALISER.msg("Enhancer.MetaDataError", (Object)metadata[i2].getFilename(), (Object)cmd.getFullClassName(), (Object)ex.getMessage()));
                        JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.MetaDataError", (Object)metadata[i2].getFilename(), (Object)cmd.getFullClassName(), (Object)ex));
                    }
                }
            }
        }
        JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.InitialiseJDOFilesEnd", (Object)("" + configList.size())));
        if (metadataIncorrect) {
            String msg = LOCALISER.msg("Enhancer.MetaDataIncorrectForEnhancing");
            System.err.println(msg);
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new Exception(msg);
        }
        return metadata;
    }

    public static String firstUpper(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    public static String getSetterName(Field f) {
        String fieldName = f.getName();
        return "Set" + fieldName;
    }

    public static String getGetterName(Field f) {
        String fieldName = f.getName();
        return "Get" + fieldName;
    }

    public static Method findMethod(ClassGen targetClasGen, String name, String signature) {
        Method[] f = targetClasGen.getMethods();
        for (int i = 0; i < f.length; ++i) {
            String methodSignature;
            Method m = f[i];
            if (!name.equals(m.getName()) || !signature.equals(methodSignature = m.getSignature())) continue;
            return m;
        }
        return null;
    }

    public static Type getJDOMethodType(Type t) {
        if (t.equals((Object)Type.BOOLEAN)) {
            return Type.BOOLEAN;
        }
        if (t == Type.BYTE) {
            return Type.BYTE;
        }
        if (t == Type.CHAR) {
            return Type.CHAR;
        }
        if (t == Type.DOUBLE) {
            return Type.DOUBLE;
        }
        if (t == Type.FLOAT) {
            return Type.FLOAT;
        }
        if (t == Type.INT) {
            return Type.INT;
        }
        if (t == Type.LONG) {
            return Type.LONG;
        }
        if (t == Type.SHORT) {
            return Type.SHORT;
        }
        if (t.equals((Object)Type.STRING)) {
            return Type.STRING;
        }
        return Type.OBJECT;
    }

    public static String getJDOMethodName(Field f) {
        return f.getName();
    }

    public static String getJDOMethodName(Type t) {
        if (t instanceof BasicType) {
            if (t.equals((Object)Type.BOOLEAN)) {
                return "Boolean";
            }
            if (t == Type.BYTE) {
                return "Byte";
            }
            if (t == Type.CHAR) {
                return "Char";
            }
            if (t == Type.DOUBLE) {
                return "Double";
            }
            if (t == Type.FLOAT) {
                return "Float";
            }
            if (t == Type.INT) {
                return "Int";
            }
            if (t == Type.LONG) {
                return "Long";
            }
            if (t == Type.SHORT) {
                return "Short";
            }
            throw new RuntimeException("unknown type" + t);
        }
        if (t.equals((Object)Type.STRING)) {
            return "String";
        }
        return "Object";
    }

    public static Instruction getBIPUSH(int i) {
        Instruction result = null;
        if (i < 6) {
            switch (i) {
                case 0: {
                    result = InstructionConstants.ICONST_0;
                    break;
                }
                case 1: {
                    result = InstructionConstants.ICONST_1;
                    break;
                }
                case 2: {
                    result = InstructionConstants.ICONST_2;
                    break;
                }
                case 3: {
                    result = InstructionConstants.ICONST_3;
                    break;
                }
                case 4: {
                    result = InstructionConstants.ICONST_4;
                    break;
                }
                case 5: {
                    result = InstructionConstants.ICONST_5;
                }
            }
        } else if (i < 127) {
            result = new BIPUSH((byte)i);
        } else if (i < Short.MAX_VALUE) {
            result = new SIPUSH((short)i);
        }
        return result;
    }

    public static ObjectType getPrimitiveWrapperType(BasicType bt) {
        if (bt.equals((Object)Type.BOOLEAN)) {
            return new ObjectType((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BCELUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
        }
        if (bt.equals((Object)Type.BYTE)) {
            return new ObjectType((class$java$lang$Byte == null ? (class$java$lang$Byte = BCELUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
        }
        if (bt.equals((Object)Type.DOUBLE)) {
            return new ObjectType((class$java$lang$Double == null ? (class$java$lang$Double = BCELUtils.class$("java.lang.Double")) : class$java$lang$Double).getName());
        }
        if (bt.equals((Object)Type.FLOAT)) {
            return new ObjectType((class$java$lang$Float == null ? (class$java$lang$Float = BCELUtils.class$("java.lang.Float")) : class$java$lang$Float).getName());
        }
        if (bt.equals((Object)Type.INT)) {
            return new ObjectType((class$java$lang$Integer == null ? (class$java$lang$Integer = BCELUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        }
        if (bt.equals((Object)Type.LONG)) {
            return new ObjectType((class$java$lang$Long == null ? (class$java$lang$Long = BCELUtils.class$("java.lang.Long")) : class$java$lang$Long).getName());
        }
        if (bt.equals((Object)Type.SHORT)) {
            return new ObjectType((class$java$lang$Short == null ? (class$java$lang$Short = BCELUtils.class$("java.lang.Short")) : class$java$lang$Short).getName());
        }
        if (bt.equals((Object)Type.CHAR)) {
            return new ObjectType((class$java$lang$Character == null ? (class$java$lang$Character = BCELUtils.class$("java.lang.Character")) : class$java$lang$Character).getName());
        }
        return new ObjectType("java.lang.Object");
    }

    public static String getBcelType2JavaTypeString(Type t) {
        String result = null;
        if (t instanceof ObjectType) {
            result = ((ObjectType)t).getClassName();
        } else if (t instanceof ArrayType) {
            result = "java.lang.Object";
        } else if (Type.BOOLEAN.getType() == t.getType()) {
            result = "boolean";
        } else if (Type.BYTE.getType() == t.getType()) {
            result = "byte";
        } else if (Type.CHAR.getType() == t.getType()) {
            result = "char";
        } else if (Type.DOUBLE.getType() == t.getType()) {
            result = "double";
        } else if (Type.FLOAT.getType() == t.getType()) {
            result = "float";
        } else if (Type.INT.getType() == t.getType()) {
            result = "int";
        } else if (Type.LONG.getType() == t.getType()) {
            result = "long";
        } else if (Type.SHORT.getType() == t.getType()) {
            result = "short";
        } else if (Type.STRING.getType() == t.getType()) {
            result = "java.lang.String";
        } else if (Type.STRINGBUFFER.getType() == t.getType()) {
            result = "java.lang.StringBuffer";
        } else if (Type.THROWABLE.getType() == t.getType()) {
            result = "java.lang.Throwable";
        } else if (Type.OBJECT.getType() == t.getType()) {
            result = "java.lang.Object";
        } else if (t != null) {
            System.out.println("unkown Type " + t.getClass().getName() + " " + t);
        }
        return result;
    }

    public static Field getFieldByName(String fieldName, ClassGen classGen) {
        Field[] f = classGen.getFields();
        if (classGen == null) {
            return null;
        }
        for (int i = 0; i < f.length; ++i) {
            if (!fieldName.equals(f[i].getName())) continue;
            return f[i];
        }
        ClassGen scg = classGen;
        if (scg.getSuperclassName() == null) {
            return null;
        }
        JavaClass jc = Repository.getRepository().findClass(scg.getSuperclassName());
        while (jc != null) {
            scg = new ClassGen(jc);
            f = scg.getFields();
            for (int i = 0; i < f.length; ++i) {
                if (!fieldName.equals(f[i].getName())) continue;
                return f[i];
            }
            if (scg.getSuperclassName() == null) {
                return null;
            }
            if (scg.getSuperclassName().equals("java.lang.Object")) {
                return null;
            }
            jc = Repository.getRepository().findClass(scg.getSuperclassName());
        }
        return null;
    }

    public static Field getFieldByName(String fieldName, JavaClass classGen) {
        Field[] f = classGen.getFields();
        if (classGen == null) {
            return null;
        }
        for (int i = 0; i < f.length; ++i) {
            if (!fieldName.equals(f[i].getName())) continue;
            return f[i];
        }
        JavaClass jc = classGen;
        if (jc.getSuperclassName() == null) {
            return null;
        }
        if (jc.getSuperclassName().equals("java.lang.Object")) {
            return null;
        }
        try {
            for (jc = jc.getSuperClass(); jc != null; jc = jc.getSuperClass()) {
                f = jc.getFields();
                for (int i = 0; i < f.length; ++i) {
                    if (!fieldName.equals(f[i].getName())) continue;
                    return f[i];
                }
                if (jc.getSuperclassName() == null) {
                    return null;
                }
                if (!jc.getSuperclassName().equals("java.lang.Object")) continue;
                return null;
            }
        }
        catch (Throwable ex) {
            JPOXLogger.ENHANCER.error((Object)LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
            throw new JDOFatalException(LOCALISER.msg("Enhancer.ClassNotFound", (Object)ex));
        }
        return null;
    }

    public static ClassGen getClassByFieldByName(String fieldName, ClassGen classGen) {
        Field[] f = classGen.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (!fieldName.equals(f[i].getName())) continue;
            return classGen;
        }
        ClassGen scg = classGen;
        if (scg.getSuperclassName() == null) {
            return null;
        }
        JavaClass jc = Repository.getRepository().findClass(scg.getSuperclassName());
        while (jc != null) {
            scg = new ClassGen(jc);
            f = scg.getFields();
            for (int i = 0; i < f.length; ++i) {
                if (!fieldName.equals(f[i].getName())) continue;
                return scg;
            }
            if (scg.getSuperclassName() == null) {
                return scg;
            }
            jc = Repository.getRepository().findClass(scg.getSuperclassName());
        }
        return null;
    }

    public static ClassGen getClassByFieldByName(String fieldName, JavaClass classGen) {
        Field[] f = classGen.getFields();
        for (int i = 0; i < f.length; ++i) {
            if (!fieldName.equals(f[i].getName())) continue;
            return new ClassGen(classGen);
        }
        ClassGen scg = new ClassGen(classGen);
        if (scg.getSuperclassName() == null) {
            return null;
        }
        JavaClass jc = Repository.getRepository().findClass(scg.getSuperclassName());
        while (jc != null) {
            scg = new ClassGen(jc);
            f = scg.getFields();
            for (int i = 0; i < f.length; ++i) {
                if (!fieldName.equals(f[i].getName())) continue;
                return scg;
            }
            if (scg.getSuperclassName() == null) {
                return scg;
            }
            jc = Repository.getRepository().findClass(scg.getSuperclassName());
        }
        return null;
    }

    public static void addSynthetic(FieldOrMethod m, ConstantPoolGen constantPoolGen) {
        Attribute[] attrs;
        int index = constantPoolGen.addUtf8("Synthetic");
        Synthetic syn = new Synthetic(index, 0, new byte[]{7}, m.getConstantPool());
        Attribute[] originalAttrs = m.getAttributes();
        if (originalAttrs == null || originalAttrs.length == 0) {
            attrs = new Attribute[]{syn};
        } else {
            for (int i = 0; i < originalAttrs.length; ++i) {
                if (!(originalAttrs[i] instanceof Synthetic)) continue;
                return;
            }
            attrs = new Attribute[originalAttrs.length + 1];
            System.arraycopy(originalAttrs, 0, attrs, 0, originalAttrs.length);
            attrs[originalAttrs.length] = syn;
        }
        m.setAttributes(attrs);
    }

    public static boolean isSynthetic(FieldOrMethod m) {
        Attribute[] attrs;
        boolean result = false;
        if (m == null) {
            result = false;
        }
        if ((attrs = m.getAttributes()) == null) {
            result = false;
        }
        for (int i = 0; i < attrs.length; ++i) {
            Attribute a = attrs[i];
            if (!(a instanceof Synthetic)) continue;
            result = true;
        }
        return result;
    }

    public static boolean isInstanceof(JavaClass targetClass, Class interfaceClass) throws ClassNotFoundException {
        if (interfaceClass == null) {
            return false;
        }
        boolean doNext = true;
        JavaClass t = targetClass;
        while (doNext) {
            JavaClass[] c = t.getInterfaces();
            String superClassName = interfaceClass.getName();
            if (c == null) {
                return false;
            }
            for (int i = 0; i < c.length; ++i) {
                if (!c[i].getClassName().equals(superClassName)) continue;
                return true;
            }
            if ((t = t.getSuperClass()) != null) continue;
            doNext = false;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

