/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.jpox.ClassLoaderResolver;
import org.jpox.util.StringUtils;

public class JPOXRepository
implements Repository {
    final ClassLoaderResolver clr;
    Map classes = new HashMap();

    public JPOXRepository(ClassLoaderResolver clr) {
        this.clr = clr;
    }

    public void clear() {
        this.classes.clear();
    }

    public JavaClass findClass(String className) {
        String resource = StringUtils.replaceAll((String)className, (String)".", (String)"/") + ".class";
        JavaClass javaClass = (JavaClass)this.classes.get(resource);
        if (javaClass == null) {
            try {
                if (this.clr.getResource(resource, null) == null) {
                    return null;
                }
                ClassParser parser = new ClassParser(this.clr.getResource(resource, null).openStream(), null);
                javaClass = parser.parse();
                javaClass.setRepository((Repository)this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassFormatException e) {
                throw new RuntimeException(e);
            }
            this.classes.put(resource, javaClass);
        }
        return javaClass;
    }

    public URL getURL(String className) {
        String resource = StringUtils.replaceAll((String)className, (String)".", (String)"/") + ".class";
        return this.clr.getResource(resource, null);
    }

    public ClassPath getClassPath() {
        return ClassPath.SYSTEM_CLASS_PATH;
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    public JavaClass loadClass(Class cls) throws ClassNotFoundException {
        return this.findClass(cls.getName());
    }

    public void removeClass(JavaClass javaClass) {
        this.classes.remove(javaClass.getClassName());
    }

    public void storeClass(JavaClass javaClass) {
        this.classes.put(javaClass.getClassName(), javaClass);
    }
}

