/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel.metadata;

import javax.jdo.JDOFatalException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;
import org.jpox.enhancer.bcel.metadata.BCELFieldMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.PackageMetaData;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class BCELClassMetaData
extends ClassMetaData {
    protected static final Localiser LOCALISER_ENH = Localiser.getInstance((String)"org.jpox.enhancer.Localisation", (ClassLoader)(class$org$jpox$enhancer$ClassEnhancer == null ? (class$org$jpox$enhancer$ClassEnhancer = BCELClassMetaData.class$("org.jpox.enhancer.ClassEnhancer")) : class$org$jpox$enhancer$ClassEnhancer).getClassLoader());
    protected final ClassGen classGen;
    protected final JavaClass enhanceClass;
    static /* synthetic */ Class class$org$jpox$enhancer$ClassEnhancer;

    public BCELClassMetaData(InterfaceMetaData imd, String implClassName, JavaClass enhanceClass) {
        super(imd, implClassName, false);
        this.enhanceClass = enhanceClass;
        Repository.addClass((JavaClass)enhanceClass);
        this.classGen = new ClassGen(this.enhanceClass);
        this.copyFieldsFromInterface(imd);
    }

    public BCELClassMetaData(PackageMetaData parent, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        super(parent, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table, entityName);
        try {
            this.enhanceClass = Repository.lookupClass((String)this.fullName);
        }
        catch (Throwable ex) {
            String msg = LOCALISER_ENH.msg("Enhancer.ClassNotFound", (Object)this.fullName, (Object)ex);
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new JDOFatalException(msg, ex);
        }
        if (this.enhanceClass == null) {
            String msg = LOCALISER_ENH.msg("Enhancer.ClassNotFound", (Object)this.fullName, (Object)"");
            JPOXLogger.ENHANCER.error((Object)msg);
            throw new JDOFatalException(msg);
        }
        this.classGen = new ClassGen(this.enhanceClass);
    }

    protected void copyFieldsFromInterface(InterfaceMetaData imd) {
        for (int i = 0; i < imd.getNoOfInheritedManagedFields() + imd.getNoOfManagedFields(); ++i) {
            BCELFieldMetaData fmd = new BCELFieldMetaData((MetaData)this, imd.getManagedFieldAbsolute(i));
            this.addProperty((AbstractPropertyMetaData)fmd);
        }
    }

    protected AbstractPropertyMetaData newDefaultedProperty(String name) {
        return new BCELFieldMetaData((MetaData)this, name);
    }

    public BCELFieldMetaData[] getManagedFieldConfigs() {
        if (this.managedFields == null) {
            return null;
        }
        int numberOfValidConfigs = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            ++numberOfValidConfigs;
        }
        BCELFieldMetaData[] managed_field_configs = new BCELFieldMetaData[numberOfValidConfigs];
        int managedFieldNum = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            managed_field_configs[managedFieldNum++] = (BCELFieldMetaData)this.managedFields[i];
        }
        return managed_field_configs;
    }

    public int getNoOfManagedFields() {
        if (this.managedFields == null) {
            return 0;
        }
        int numberOfValidConfigs = 0;
        for (int i = 0; i < this.managedFields.length; ++i) {
            if (!this.managedFields[i].fieldBelongsToClass()) continue;
            ++numberOfValidConfigs;
        }
        return numberOfValidConfigs;
    }

    public ClassGen getClassGen() {
        return this.classGen;
    }

    public JavaClass getEnhanceClass() {
        return this.enhanceClass;
    }

    public BCELFieldMetaData findField(Field f) {
        if (f == null) {
            throw new NullPointerException("field is null");
        }
        String name = f.getName();
        for (int i = 0; i < this.properties.size(); ++i) {
            BCELFieldMetaData fieldConfig = (BCELFieldMetaData)this.getField(i);
            if (!fieldConfig.fieldBelongsToClass() || !fieldConfig.getEnhanceField().getName().equals(name)) continue;
            return fieldConfig;
        }
        if (this.pcSuperclassMetaData != null) {
            return ((BCELClassMetaData)this.pcSuperclassMetaData).findField(f);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

