/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import org.jpox.ClassLoaderResolver;
import org.jpox.PMFContext;
import org.jpox.enhancer.bcel.metadata.BCELClassMetaData;
import org.jpox.enhancer.bcel.metadata.BCELFieldMetaData;
import org.jpox.enhancer.bcel.metadata.BCELPropertyMetaData;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.FieldMetaData;
import org.jpox.metadata.FileMetaData;
import org.jpox.metadata.JDOMetaDataManager;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.metadata.MetaDataParser;
import org.jpox.metadata.PackageMetaData;
import org.jpox.metadata.PropertyMetaData;
import org.jpox.util.JPOXLogger;

public class BCELMetaDataManager
extends JDOMetaDataManager {
    public BCELMetaDataManager(PMFContext context) {
        super(context);
        this.enhancing = true;
    }

    public ClassMetaData newClassObject(PackageMetaData pmd, String name, String identityType, String objectidClass, String requiresExtent, String detachable, String embeddedOnly, String modifier, String persistenceCapableSuperclass, String catalog, String schema, String table, String entityName) {
        BCELClassMetaData cmd = new BCELClassMetaData(pmd, name, identityType, objectidClass, requiresExtent, detachable, embeddedOnly, modifier, persistenceCapableSuperclass, catalog, schema, table, entityName);
        return cmd;
    }

    public FieldMetaData newFieldObject(MetaData md, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String deleteAction, String indexed, String unique, String recursionDepth, String loadFetchGroup, String valueStrategy, String sequence, String fieldType) {
        BCELFieldMetaData fmd = new BCELFieldMetaData(md, name, pk, modifier, defaultFetchGroup, nullValue, embedded, serialized, dependent, mappedBy, column, table, deleteAction, indexed, unique, recursionDepth, loadFetchGroup, valueStrategy, sequence, fieldType);
        return fmd;
    }

    public PropertyMetaData newPropertyObject(MetaData md, String name, String pk, String modifier, String defaultFetchGroup, String nullValue, String embedded, String serialized, String dependent, String mappedBy, String column, String table, String deleteAction, String indexed, String unique, String recursionDepth, String loadFetchGroup, String valueStrategy, String sequence, String fieldType, String fieldName) {
        BCELPropertyMetaData pmd = new BCELPropertyMetaData(md, name, pk, modifier, defaultFetchGroup, nullValue, embedded, serialized, dependent, mappedBy, column, table, deleteAction, indexed, unique, recursionDepth, loadFetchGroup, valueStrategy, sequence, fieldType, fieldName);
        return pmd;
    }

    protected FileMetaData parseFile(URL file_url) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser((MetaDataManager)this, this.validateMetaData);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(file_url, "jdo-enhancer");
    }

    public FileMetaData parseAndRegisterClass(String className, ClassLoaderResolver clr) {
        Class cls = clr.classForName(className);
        ClassMetaData cmd = (ClassMetaData)this.classMetaDataByClass.get(className);
        FileMetaData filemd = null;
        if (cmd == null) {
            filemd = this.loadAnnotationsForClass(cls, clr, false);
            if (filemd != null) {
                this.registerFile("annotations:" + className, filemd);
            }
        } else {
            filemd = cmd.getPackageMetaData().getFileMetaData();
        }
        return filemd;
    }

    public FileMetaData parseAndRegisterFile(String filename, ClassLoaderResolver clr) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser((MetaDataManager)this, this.validateMetaData);
        }
        FileMetaData filemd = (FileMetaData)this.metaDataParser.parseMetaDataFile(filename, "jdo-enhancer");
        URL fileURL = null;
        try {
            fileURL = new URL("file:" + filename);
        }
        catch (MalformedURLException mue) {
            fileURL = clr.getResource(filename, null);
        }
        if (filemd != null) {
            this.registerFile(fileURL.toString(), filemd);
        }
        return filemd;
    }

    public void populateRegisteredFile(FileMetaData filemd, ClassLoaderResolver clr) {
        this.populateFileMetaData(filemd, clr, null);
    }

    public void initialiseClassMetaData(ClassMetaData cmd, ClassLoaderResolver clr) {
        try {
            Class c = clr.classForName(cmd.getFullClassName(), false);
            this.initialiseClassMetaData(cmd, c, clr);
        }
        catch (ClassNotResolvedException cnre) {
            JPOXLogger.ENHANCER.error((Object)("Error finding class " + cmd.getFullClassName()));
        }
    }

    protected void initialiseClassMetaData(ClassMetaData cmd, Class cls, ClassLoaderResolver clr) {
        if (!cmd.isPopulated() && !cmd.isInitialised()) {
            cmd.populate(clr, cls.getClassLoader());
        }
        if (!cmd.isInitialised()) {
            cmd.initialise();
        }
    }
}

