/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel.method;

import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jpox.enhancer.bcel.BCELClassEnhancer;
import org.jpox.enhancer.bcel.BCELUtils;
import org.jpox.enhancer.bcel.metadata.BCELFieldMetaData;
import org.jpox.enhancer.bcel.method.MethodBuilder;

public class InitFieldTypes
extends MethodBuilder {
    public InitFieldTypes(String methodName, int type, Type resultType, Type[] argType, String[] argName, boolean synthetic, BCELClassEnhancer gen) {
        super(methodName, type, resultType, argType, argName, synthetic, gen);
    }

    public static InitFieldTypes getInstance(BCELClassEnhancer gen) {
        return new InitFieldTypes("__jdoFieldTypesInit", 26, (Type)new ArrayType((Type)BCELClassEnhancer.OT_CLASS, 1), Type.NO_ARGS, null, true, gen);
    }

    protected void loadClass(Field f) {
        Type t = f.getType();
        if (t instanceof BasicType) {
            String primitiveClassName = BCELUtils.getPrimitiveWrapperType((BasicType)f.getType()).getClassName();
            this.il.append((Instruction)this.factory.createGetStatic(primitiveClassName, "TYPE", (Type)BCELClassEnhancer.OT_CLASS));
        } else if (t instanceof ArrayType) {
            String classSig = f.getType().getSignature();
            int cpIndex = this.constantPoolGen.addString(classSig.replace('/', '.'));
            this.il.append((Instruction)new LDC(cpIndex));
            this.il.append((Instruction)this.factory.createInvoke(this.className, "___jdo$loadClass", (Type)BCELClassEnhancer.OT_CLASS, new Type[]{Type.STRING}, (short)184));
        } else {
            int cpIndex = this.constantPoolGen.addString(((ObjectType)t).getClassName());
            this.il.append((Instruction)new LDC(cpIndex));
            this.il.append((Instruction)this.factory.createInvoke(this.className, "___jdo$loadClass", (Type)BCELClassEnhancer.OT_CLASS, new Type[]{Type.STRING}, (short)184));
        }
    }

    public void execute() {
        int fieldNum = this.classConfig.getNoOfManagedFields();
        BCELFieldMetaData[] targetFields = this.classConfig.getManagedFieldConfigs();
        this.il.append(BCELUtils.getBIPUSH(fieldNum));
        this.il.append(this.factory.createNewArray((Type)BCELClassEnhancer.OT_CLASS, (short)1));
        for (int i = 0; i < fieldNum; ++i) {
            this.il.append((Instruction)InstructionConstants.DUP);
            this.il.append(BCELUtils.getBIPUSH(i));
            this.loadClass(targetFields[i].getEnhanceField());
            this.il.append((Instruction)InstructionConstants.AASTORE);
        }
        this.il.append((Instruction)InstructionConstants.ARETURN);
    }
}

