/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel.method;

import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.jpox.enhancer.ClassEnhancer;
import org.jpox.enhancer.bcel.BCELClassEnhancer;
import org.jpox.enhancer.bcel.BCELUtils;
import org.jpox.enhancer.bcel.metadata.BCELFieldMetaData;
import org.jpox.enhancer.bcel.method.MethodBuilder;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.util.AIDUtils;

public class JdoCopyKeyFieldsToObjectId2
extends MethodBuilder {
    public JdoCopyKeyFieldsToObjectId2(String methodName, int type, Type resultType, Type[] argType, String[] argName, boolean synthetic, BCELClassEnhancer gen) {
        super(methodName, type, resultType, argType, argName, synthetic, gen);
    }

    public static JdoCopyKeyFieldsToObjectId2 getInstance(BCELClassEnhancer gen) {
        return new JdoCopyKeyFieldsToObjectId2("jdoCopyKeyFieldsToObjectId", 17, (Type)Type.VOID, new Type[]{BCELClassEnhancer.OT_ObjectIdFieldSupplier, Type.OBJECT}, new String[]{"fs", "oid"}, false, gen);
    }

    public void execute() {
        InstructionHandle[] lv_o = new InstructionHandle[2];
        String oidClassName = this.classConfig.getObjectidClass();
        BCELFieldMetaData[] fields = this.classConfig.getManagedFieldConfigs();
        if (AIDUtils.isSingleFieldIdentityClass((String)oidClassName)) {
            this.createThrowException(ClassEnhancer.CN_JDOFatalInternalException, "It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
            this.il.append((Instruction)InstructionConstants.RETURN);
        } else if (oidClassName != null && oidClassName.length() > 0) {
            BCELFieldMetaData[] targetFields = this.classConfig.getManagedFieldConfigs();
            ObjectType oidType = new ObjectType(oidClassName);
            this.il.append((Instruction)InstructionConstants.ALOAD_1);
            IFNONNULL checkFmNotNull = new IFNONNULL(null);
            this.il.append((BranchInstruction)checkFmNotNull);
            this.createThrowException(ClassEnhancer.CN_IllegalArgumentException, "ObjectIdFieldSupplier is null");
            checkFmNotNull.setTarget(this.il.append((Instruction)InstructionConstants.ALOAD_2));
            this.il.append((Instruction)this.factory.createInstanceOf((ReferenceType)oidType));
            this.il.append(InstructionConstants.ICONST_1);
            IF_ICMPEQ isInstanceof = new IF_ICMPEQ(null);
            this.il.append((BranchInstruction)isInstanceof);
            this.createThrowException(ClassEnhancer.CN_ClassCastException, "oid is not instanceof " + oidClassName);
            isInstanceof.setTarget(this.il.append((Instruction)InstructionConstants.ALOAD_2));
            this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)oidType));
            lv_o[0] = this.il.append((Instruction)new ASTORE(3));
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    MetaDataManager mgr;
                    AbstractClassMetaData cmd;
                    BCELFieldMetaData f = fields[i];
                    if (!f.isPrimaryKey()) continue;
                    this.il.append((Instruction)InstructionFactory.createLoad((Type)oidType, (int)3));
                    Field field = targetFields[i].getEnhanceField();
                    this.il.append((Instruction)InstructionConstants.ALOAD_1);
                    this.il.append(BCELUtils.getBIPUSH(i));
                    String paramName = BCELUtils.getJDOMethodName(field.getType());
                    this.il.append((Instruction)this.factory.createInvoke(ClassEnhancer.CN_ObjectIdFieldSupplier, "fetch" + paramName + "Field", BCELUtils.getJDOMethodType(field.getType()), new Type[]{Type.INT}, (short)185));
                    if (BCELUtils.getJDOMethodType(field.getType()) == Type.OBJECT) {
                        String type = null;
                        type = field.getType() instanceof ArrayType ? field.getType().getSignature() : field.getType().toString();
                        this.il.append((Instruction)new CHECKCAST(this.constantPoolGen.addClass(type)));
                    }
                    if ((cmd = (mgr = this.classConfig.getMetaDataManager()).getMetaDataForClass(f.getType(), this.gen.getClassLoaderResolver())) != null) {
                        this.il.append((Instruction)this.factory.createInvoke(ClassEnhancer.CN_JDOHelper, "getObjectId", (Type)Type.OBJECT, new Type[]{Type.OBJECT}, (short)184));
                        ObjectType OT_objectidclass = new ObjectType(cmd.getObjectidClass());
                        this.il.append(this.factory.createCast((Type)Type.OBJECT, (Type)OT_objectidclass));
                        this.il.append((Instruction)this.factory.createPutField(oidClassName, f.getName(), (Type)OT_objectidclass));
                        continue;
                    }
                    this.il.append((Instruction)this.factory.createPutField(oidClassName, f.getName(), f.getEnhanceField().getType()));
                }
            }
            lv_o[1] = this.il.append((Instruction)InstructionConstants.RETURN);
            this.methodGen.addLocalVariable("o", (Type)oidType, lv_o[0], lv_o[1]);
        } else {
            this.il.append((Instruction)InstructionConstants.RETURN);
        }
    }
}

