/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.enhancer.bcel.method;

import java.util.Arrays;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.jpox.enhancer.ClassEnhancer;
import org.jpox.enhancer.bcel.BCELClassEnhancer;
import org.jpox.enhancer.bcel.BCELUtils;
import org.jpox.enhancer.bcel.method.ClassElementBuilder;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class MethodBuilder
extends ClassElementBuilder {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.jpox.enhancer.Localisation", (ClassLoader)(class$org$jpox$enhancer$ClassEnhancer == null ? (class$org$jpox$enhancer$ClassEnhancer = MethodBuilder.class$("org.jpox.enhancer.ClassEnhancer")) : class$org$jpox$enhancer$ClassEnhancer).getClassLoader());
    protected String methodName;
    protected int type;
    protected Type resultType;
    protected Type[] argType;
    protected String[] argName;
    protected InstructionFactory factory;
    protected InstructionList il;
    protected MethodGen methodGen;
    protected boolean synthetic;
    static /* synthetic */ Class class$org$jpox$enhancer$ClassEnhancer;

    public MethodBuilder(String methodName, int type, Type resultType, Type[] argType, String[] argName, boolean synthetic, BCELClassEnhancer gen) {
        super(gen);
        this.methodName = methodName;
        this.type = type;
        this.resultType = resultType;
        this.argType = argType;
        this.argName = argName;
        this.synthetic = synthetic;
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MethodBuilder) {
            MethodBuilder cb = (MethodBuilder)o;
            if (cb.methodName.equals(this.methodName)) {
                return Arrays.equals(cb.argType, this.argType);
            }
        }
        return false;
    }

    public void init() {
        this.factory = new InstructionFactory(this.classGen);
        this.il = new InstructionList();
        this.methodGen = new MethodGen(this.type, this.resultType, this.argType, this.argName, this.methodName, this.className, this.il, this.classGen.getConstantPool());
    }

    public void execute() {
        if (this.resultType.equals((Object)Type.VOID)) {
            this.il.append((Instruction)InstructionConstants.RETURN);
        } else if (this.resultType instanceof ReferenceType) {
            this.il.append(InstructionConstants.ACONST_NULL);
            this.il.append((Instruction)InstructionConstants.ARETURN);
        } else if (Type.LONG.equals((Object)this.resultType)) {
            this.il.append(InstructionConstants.LCONST_0);
            this.il.append((Instruction)InstructionConstants.LRETURN);
        } else if (Type.DOUBLE.equals((Object)this.resultType)) {
            this.il.append(InstructionConstants.DCONST_0);
            this.il.append((Instruction)InstructionConstants.DRETURN);
        } else if (Type.FLOAT.equals((Object)this.resultType)) {
            this.il.append(InstructionConstants.FCONST_0);
            this.il.append((Instruction)InstructionConstants.FRETURN);
        } else {
            this.il.append(InstructionConstants.ICONST_0);
            this.il.append((Instruction)InstructionConstants.IRETURN);
        }
    }

    public void close() {
        if (this.methodGen != null) {
            this.methodGen.setMaxStack();
            this.methodGen.setMaxLocals();
            Method m = this.methodGen.getMethod();
            this.classGen.addMethod(m);
            if (this.synthetic) {
                BCELUtils.addSynthetic((FieldOrMethod)m, this.classGen.getConstantPool());
            }
            if (JPOXLogger.ENHANCER.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.methodName).append("(");
                for (int i = 0; i < this.argType.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(this.argType[i]).append(" ").append(this.argName[i]);
                }
                sb.append(")");
                JPOXLogger.ENHANCER.debug((Object)LOCALISER.msg("Enhancer.AddMethod", (Object)sb.toString()));
            }
            this.methodGen.update();
            this.classGen.update();
            this.il.dispose();
        }
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    protected InstructionHandle createThrowException(String newException, String message, Instruction intMessage) {
        InstructionHandle result = this.il.append((Instruction)this.factory.createNew(newException));
        this.il.append((Instruction)InstructionConstants.DUP);
        this.il.append((Instruction)this.factory.createNew(Type.STRINGBUFFER));
        this.il.append((Instruction)InstructionConstants.DUP);
        this.il.append((Instruction)new LDC(this.classGen.getConstantPool().addString(message)));
        this.il.append((Instruction)this.factory.createInvoke(Type.STRINGBUFFER.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        this.il.append(intMessage);
        this.il.append((Instruction)this.factory.createInvoke(Type.STRINGBUFFER.getClassName(), "append", (Type)Type.STRINGBUFFER, new Type[]{Type.INT}, (short)182));
        this.il.append((Instruction)this.factory.createInvoke(Type.STRINGBUFFER.getClassName(), "toString", (Type)Type.STRING, Type.NO_ARGS, (short)182));
        this.il.append((Instruction)this.factory.createInvoke(ClassEnhancer.CN_IllegalArgumentException, "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        this.il.append(InstructionConstants.ATHROW);
        return result;
    }

    protected InstructionHandle createThrowException(String newException, String message) {
        InstructionHandle result = this.il.append((Instruction)this.factory.createNew(newException));
        this.il.append((Instruction)InstructionConstants.DUP);
        this.il.append((Instruction)new LDC(this.classGen.getConstantPool().addString(message)));
        this.il.append((Instruction)this.factory.createInvoke(newException, "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        this.il.append(InstructionConstants.ATHROW);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

