/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSONPathExtractor
extends AbstractTestElement
implements PostProcessor {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 1L;
    private static final String JSONPATH = "JSONPATH";
    private static final String VAR = "VAR";
    private static final String DEFAULT = "DEFAULT";

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getVar() {
        return this.getPropertyAsString(VAR);
    }

    public void setVar(String var) {
        this.setProperty(VAR, var);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    private String extractJSONPath(String jsonString, String jsonPath) throws Exception {
        Object jsonPathResult = JsonPath.read((String)jsonString, (String)jsonPath, (Filter[])new Filter[0]);
        if (null == jsonPathResult) {
            return this.getDefaultValue();
        }
        return jsonPathResult.toString();
    }

    public void process() {
        String response;
        JMeterContext context = this.getThreadContext();
        JMeterVariables vars = context.getVariables();
        SampleResult previousResult = context.getPreviousResult();
        String responseData = previousResult.getResponseDataAsString();
        try {
            response = this.extractJSONPath(responseData, this.getJsonPath());
        }
        catch (Exception e) {
            log.error("Extract failed", (Throwable)e);
            response = this.getDefaultValue();
        }
        vars.put(this.getVar(), response);
    }
}

