/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.gui;

import com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.JSONPathExtractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;

public class JSONPathExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 1L;
    private JTextField variableNameTextField = null;
    private JTextField jsonPathTextField = null;
    private JTextField defaultValTextField = null;
    private static final String WIKIPAGE = "JSONPathExtractor";

    public JSONPathExtractorGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Variable Name: ", 4));
        this.variableNameTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.variableNameTextField);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("JSON Path: ", 4));
        this.jsonPathTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.jsonPathTextField);
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Default Value: ", 4));
        this.defaultValTextField = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.defaultValTextField);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public void clearGui() {
        super.clearGui();
        this.variableNameTextField.setText("");
        this.jsonPathTextField.setText("");
        this.defaultValTextField.setText("");
    }

    public TestElement createTestElement() {
        JSONPathExtractor extractor = new JSONPathExtractor();
        this.modifyTestElement((TestElement)extractor);
        extractor.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return extractor;
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("JSON Path Extractor");
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            extractor.setVar(this.variableNameTextField.getText());
            extractor.setJsonPath(this.jsonPathTextField.getText());
            extractor.setDefaultValue(this.defaultValTextField.getText());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            this.variableNameTextField.setText(extractor.getVar());
            this.jsonPathTextField.setText(extractor.getJsonPath());
            this.defaultValTextField.setText(extractor.getDefaultValue());
        }
    }
}

