/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.rest.gui;

import com.atlantbh.jmeter.plugins.rest.RestSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class RestGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = -5576774730632101012L;
    private JCheckBox useKeepAlive;
    private JCheckBox automaticRedirect;
    private JLabeledTextArea body;
    private JLabeledTextArea headers;
    private JLabeledTextField hostBaseUrl;
    private JLabeledTextField resource;
    private JLabeledTextField port;
    private JLabeledChoice httpMethods;
    private static final String WIKIPAGE = "RESTSampler";

    public RestGui() {
        this.init();
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("REST Sampler");
    }

    public TestElement createTestElement() {
        RestSampler sampler = new RestSampler();
        this.modifyTestElement((TestElement)sampler);
        sampler.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return sampler;
    }

    public void clear() {
        this.httpMethods.setText("GET");
        this.hostBaseUrl.setText("");
        this.headers.setText("");
        this.resource.setText("");
        this.port.setText("8080");
        this.useKeepAlive.setSelected(true);
        this.automaticRedirect.setSelected(true);
        this.body.setText("");
    }

    public void modifyTestElement(TestElement s) {
        super.configureTestElement(s);
        if (s instanceof RestSampler) {
            RestSampler sampler = (RestSampler)s;
            sampler.setRequestBody(this.body.getText());
            sampler.setMethod(this.httpMethods.getText());
            sampler.setUseKeepAlive(this.useKeepAlive.isSelected());
            sampler.setAutoRedirects(this.automaticRedirect.isSelected());
            sampler.setHostBaseUrl(this.hostBaseUrl.getText());
            sampler.setResource(this.resource.getText());
            sampler.setPortNumber(this.port.getText());
            sampler.setRequestHeaders(this.headers.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.clear();
    }

    private JPanel getResourceConfigPanel() {
        this.automaticRedirect = new JCheckBox(JMeterUtils.getResString((String)"follow_redirects"));
        this.httpMethods = new JLabeledChoice("Method", new String[]{"GET", "POST", "PUT", "DELETE"});
        this.httpMethods.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JLabeledChoice c = (JLabeledChoice)e.getSource();
                String text = c.getText();
                if ("PUT".equals(text) || "POST".equals(text)) {
                    RestGui.this.automaticRedirect.setSelected(false);
                    RestGui.this.automaticRedirect.setEnabled(false);
                } else {
                    RestGui.this.automaticRedirect.setEnabled(true);
                }
            }
        });
        this.useKeepAlive = new JCheckBox(JMeterUtils.getResString((String)"use_keepalive"));
        this.hostBaseUrl = new JLabeledTextField("Base Url", 25);
        this.resource = new JLabeledTextField("Resource", 20);
        this.port = new JLabeledTextField("Port", 10);
        VerticalPanel panel = new VerticalPanel();
        HorizontalPanel panel1 = new HorizontalPanel();
        panel1.add((Component)this.httpMethods);
        panel1.add((Component)this.useKeepAlive);
        panel1.add((Component)this.automaticRedirect);
        HorizontalPanel panel2 = new HorizontalPanel();
        panel2.add((Component)this.hostBaseUrl);
        panel2.add((Component)this.port);
        HorizontalPanel panel3 = new HorizontalPanel();
        panel3.add((Component)this.resource);
        panel.add((Component)panel1);
        panel.add((Component)panel2);
        panel.add((Component)panel3);
        return panel;
    }

    private JPanel getRequestPanel() {
        this.body = new JLabeledTextArea("Body");
        this.headers = new JLabeledTextArea("Headers");
        VerticalPanel panel = new VerticalPanel();
        panel.add((Component)this.headers, (Object)"North");
        panel.add((Component)this.body, (Object)"Center");
        return panel;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)this.getResourceConfigPanel(), (Object)"North");
        panel.add((Component)this.getRequestPanel(), (Object)"Center");
        this.add((Component)panel, "Center");
    }

    public void configure(TestElement el) {
        super.configure(el);
        RestSampler sampler = (RestSampler)el;
        this.body.setText(sampler.getRequestBody());
        this.headers.setText(sampler.getRequestHeaders());
        this.useKeepAlive.setSelected(sampler.getUseKeepAlive());
        this.automaticRedirect.setSelected(sampler.getAutoRedirects());
        this.httpMethods.setText(sampler.getMethod());
        this.resource.setText(sampler.getResource());
        this.port.setText(sampler.getPortNumber());
        this.hostBaseUrl.setText(sampler.getHostBaseUrl());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

