/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class VariableFromCsvFileReader {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private BufferedReader input;

    public VariableFromCsvFileReader(String csvFileName) {
        try {
            this.input = new BufferedReader(new FileReader(csvFileName));
        }
        catch (FileNotFoundException ex) {
            log.error("File not found: " + ex.getMessage());
        }
    }

    public VariableFromCsvFileReader(BufferedReader input) {
        this.input = input;
    }

    public Map<String, String> getDataAsMap(String prefix, String separator) {
        return this.getDataAsMap(prefix, separator, 0);
    }

    public Map<String, String> getDataAsMap(String prefix, String separator, int skipLines) {
        if (separator.isEmpty()) {
            throw new IllegalArgumentException("CSV separator cannot be empty");
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.input != null) {
            try {
                String line;
                int lineNum = 0;
                while ((line = this.input.readLine()) != null) {
                    if (++lineNum <= skipLines) continue;
                    String[] lineValues = JOrphanUtils.split((String)line, (String)separator, (boolean)false);
                    if (lineValues.length == 1) {
                        log.warn("Less than 2 columns at line: " + line);
                        variables.put(prefix + lineValues[0], "");
                        continue;
                    }
                    if (lineValues.length < 2) continue;
                    variables.put(prefix + lineValues[0], lineValues[1]);
                }
            }
            catch (IOException ex) {
                log.error("Error while reading: " + ex.getMessage());
            }
        }
        return variables;
    }
}

