/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;

public class ChooseRandom
extends AbstractFunction {
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__chooseRandom";
    private static final Random random = new Random(System.currentTimeMillis());
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        String varName = ((CompoundVariable)this.values[this.values.length - 1]).execute().trim();
        int index = random.nextInt(this.values.length - 1);
        String choice = ((CompoundVariable)this.values[index]).execute();
        if (vars != null && varName != null && varName.length() > 0) {
            vars.put(varName, choice);
        }
        return choice;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 3);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add("Any number of values to choose from");
        desc.add("Last value must be variable name where choice will be stored");
    }
}

