/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.jmxmon;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.jmxmon.JMXMonSampleGenerator;
import kg.apc.jmeter.jmxmon.JMXMonSampleResult;
import kg.apc.jmeter.jmxmon.JMXMonSampler;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXMonCollector
extends CorrectedResultCollector
implements Runnable,
JMXMonSampleGenerator {
    private static final long serialVersionUID = 1437356057522465756L;
    private static final boolean autoGenerateFiles;
    private static final String JMXMON = "JmxMon";
    private static final Logger log;
    public static final String DATA_PROPERTY = "samplers";
    private int interval;
    private Thread workerThread = null;
    protected List<JMXMonSampler> jmxMonSamplers = new ArrayList<JMXMonSampler>();
    private String autoFileBaseName = null;
    private static int counter;
    private String workerHost = null;

    private synchronized String getAutoFileName() {
        String ret = "";
        ++counter;
        if (this.autoFileBaseName == null) {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            this.autoFileBaseName = "jmxMon_" + formatter.format(now.getTime());
        }
        ret = ret + this.autoFileBaseName;
        if (counter > 1) {
            ret = ret + "_" + counter;
        }
        ret = ret + ".csv";
        return ret;
    }

    public JMXMonCollector() {
        this.interval = JMeterUtils.getPropDefault((String)"jmeterPlugin.jmxmon.interval", (int)1000);
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getSamplerSettings() {
        return this.getProperty(DATA_PROPERTY);
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                this.processConnectors();
                this.wait(this.interval);
            }
        }
        catch (InterruptedException ex) {
            log.debug("Monitoring thread was interrupted", (Throwable)ex);
            return;
        }
    }

    private synchronized boolean isWorkingHost(String host) {
        if (this.workerHost == null) {
            this.workerHost = host;
            return true;
        }
        return host.equals(this.workerHost);
    }

    @Override
    public void testStarted(String host) {
        if (!this.isWorkingHost(host)) {
            return;
        }
        if (this.getProperty("filename") == null || this.getProperty("filename").getStringValue().trim().length() == 0) {
            if (autoGenerateFiles) {
                this.setupSaving(this.getAutoFileName());
            } else {
                log.info("JmxMon metrics will not be recorded! Please specify a file name in the gui or run the test with -JforceJmxMonFile=true");
            }
        }
        try {
            this.initiateConnectors();
        }
        catch (MalformedURLException ex) {
            log.error("Malformed JMX url", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error("IOException reading JMX", (Throwable)ex);
        }
        this.workerThread = new Thread(this);
        this.workerThread.start();
        super.testStarted(host);
    }

    private void setupSaving(String fileName) {
        SampleSaveConfiguration config = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(config);
        this.setSaveConfig(config);
        this.setFilename(fileName);
        log.info("JMXMon metrics will be stored in " + new File(fileName).getAbsolutePath());
    }

    public void testEnded(String host) {
        log.debug("Start testEnded");
        this.workerHost = null;
        if (this.workerThread == null) {
            log.debug("End   testEnded workerThread == null");
            return;
        }
        this.workerThread.interrupt();
        this.shutdownConnectors();
        this.autoFileBaseName = null;
        counter = 0;
        super.testEnded(host);
        log.debug("End   testEnded");
    }

    private void initiateConnectors() throws IOException {
        JMeterProperty prop = this.getSamplerSettings();
        this.jmxMonSamplers.clear();
        if (!(prop instanceof CollectionProperty)) {
            log.warn("Got unexpected property: " + prop);
            return;
        }
        CollectionProperty rows = (CollectionProperty)prop;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String label = ((JMeterProperty)row.get(0)).getStringValue();
            String jmxUrl = ((JMeterProperty)row.get(1)).getStringValue();
            String username = ((JMeterProperty)row.get(2)).getStringValue();
            String password = ((JMeterProperty)row.get(3)).getStringValue();
            String objectName = ((JMeterProperty)row.get(4)).getStringValue();
            String attribute = ((JMeterProperty)row.get(5)).getStringValue();
            String key = ((JMeterProperty)row.get(6)).getStringValue();
            boolean isDelta = ((JMeterProperty)row.get(7)).getBooleanValue();
            JMXServiceURL u = new JMXServiceURL(jmxUrl);
            Hashtable<String, String[]> attributes = new Hashtable<String, String[]>();
            String[] buffer = new String[]{username, password};
            attributes.put("jmx.remote.credentials", buffer);
            this.initiateConnector(u, attributes, jmxUrl, label, isDelta, objectName, attribute, key);
        }
    }

    protected void initiateConnector(JMXServiceURL u, Hashtable attributes, String jmxUrl, String name, boolean delta, String objectName, String attribute, String key) throws IOException {
        JMXConnector jmxConnector = null;
        MBeanServerConnection mBeanServerConn = this.findConnectionSameUrl(jmxUrl);
        if (mBeanServerConn == null) {
            log.debug("Create new connection url = " + jmxUrl);
            jmxConnector = JMXConnectorFactory.connect(u, attributes);
            mBeanServerConn = jmxConnector.getMBeanServerConnection();
        } else {
            log.debug("Reused the same connection for url = " + jmxUrl);
        }
        this.jmxMonSamplers.add(new JMXMonSampler(mBeanServerConn, jmxConnector, jmxUrl, name, objectName, attribute, key, delta));
    }

    private MBeanServerConnection findConnectionSameUrl(String url) {
        MBeanServerConnection conn = null;
        boolean continueFind = true;
        Iterator<JMXMonSampler> it = this.jmxMonSamplers.iterator();
        while (it.hasNext() && continueFind) {
            JMXMonSampler jmxSampler = it.next();
            String urlTemp = jmxSampler.getUrl();
            if (urlTemp == null || !urlTemp.equals(url)) continue;
            conn = jmxSampler.getRemote();
            continueFind = false;
        }
        return conn;
    }

    private void shutdownConnectors() {
        log.debug("Start shutdownConnectors");
        for (JMXMonSampler jmxSampler : this.jmxMonSamplers) {
            JMXConnector jmxConnector = jmxSampler.getJmxConnector();
            if (jmxConnector != null) {
                try {
                    jmxConnector.close();
                    log.debug("jmx connector is closed");
                }
                catch (Exception ex) {
                    log.debug("Can't close jmx connector, but continue");
                }
                continue;
            }
            log.debug("jmxConnector == null, don't try to close connection");
        }
        this.jmxMonSamplers.clear();
        log.debug("End  shutdownConnectors");
    }

    protected void processConnectors() {
        for (JMXMonSampler sampler : this.jmxMonSamplers) {
            sampler.generateSamples(this);
        }
    }

    public void sampleOccurred(SampleEvent event) {
    }

    protected void jmxMonSampleOccurred(SampleEvent event) {
        super.sampleOccurred(event);
    }

    @Override
    public void generateSample(double value, String label) {
        JMXMonSampleResult res = new JMXMonSampleResult();
        res.setSampleLabel(label);
        res.setValue(value);
        res.setSuccessful(true);
        SampleEvent e = new SampleEvent((SampleResult)res, JMXMON);
        this.jmxMonSampleOccurred(e);
    }

    static {
        log = LoggingManager.getLoggerForClass();
        counter = 0;
        autoGenerateFiles = JMeterUtils.getPropDefault((String)"forceJmxMonFile", (String)"false").trim().equalsIgnoreCase("true");
    }
}

