/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.listener;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import kg.apc.jmeter.PluginsCMDWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GraphsGeneratorListener
extends AbstractListenerElement
implements TestStateListener,
TestBean,
TestElement,
Visualizer {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = -136031193118302572L;
    private static final String[] pluginTypes = new String[]{"ResponseTimesOverTime", "HitsPerSecond", "BytesThroughputOverTime", "LatenciesOverTime", "ResponseCodesPerSecond", "TransactionsPerSecond", "ResponseTimesDistribution", "ResponseTimesPercentiles", "ThreadsStateOverTime", "TimesVsThreads", "ThroughputVsThreads"};
    private static final Set<String> TIME_BASED_GRAPHS = new HashSet<String>();
    private String resultsFileName;
    private ExportMode exportMode;
    private String filePrefix;
    private int graphWidth;
    private int graphHeight;
    private boolean aggregateRows;
    private String paintMarkers;
    private boolean paintZeroing;
    private boolean paintGradient;
    private boolean preventOutliers;
    private boolean relativeTimes;
    private boolean autoScaleRows;
    private String limitRows;
    private String forceY;
    private String granulation;
    private String lineWeight;
    private String lowCountLimit;
    private String successFilter;
    private String includeLabels;
    private String excludeLabels;

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        for (int i = 0; i < pluginTypes.length; ++i) {
            PluginsCMDWorker worker = new PluginsCMDWorker();
            worker.setInputFile(this.resultsFileName);
            worker.setGraphWidth(this.graphWidth);
            worker.setGraphHeight(this.graphHeight);
            if (!StringUtils.isEmpty((CharSequence)this.forceY)) {
                worker.setForceY(Integer.parseInt(this.forceY));
            }
            if (!StringUtils.isEmpty((CharSequence)this.limitRows)) {
                worker.setRowsLimit(Integer.parseInt(this.limitRows));
            }
            worker.setAggregate(this.aggregateRows ? 1 : 0);
            worker.setPreventOutliers(this.preventOutliers ? 1 : 0);
            worker.setAggregate(this.aggregateRows ? 1 : 0);
            if (!StringUtils.isEmpty((CharSequence)this.paintMarkers)) {
                worker.setMarkers("True".equalsIgnoreCase(this.paintMarkers) ? 1 : 0);
            }
            worker.setZeroing(this.paintZeroing ? 1 : 0);
            if (GraphsGeneratorListener.isTimeBasedGraph(pluginTypes[i])) {
                worker.setRelativeTimes(this.relativeTimes ? 1 : 0);
            }
            worker.setGradient(this.paintGradient ? 1 : 0);
            worker.setAutoScaleRows(this.autoScaleRows ? 1 : 0);
            if (!StringUtils.isEmpty((CharSequence)this.successFilter)) {
                worker.setSuccessFilter("True".equalsIgnoreCase(this.successFilter) ? 1 : 0);
            }
            if (!StringUtils.isEmpty((CharSequence)this.granulation)) {
                worker.setGranulation(Integer.parseInt(this.granulation));
            }
            if (!StringUtils.isEmpty((CharSequence)this.lineWeight)) {
                worker.setLineWeight(Float.parseFloat(this.lineWeight));
            }
            if (!StringUtils.isEmpty((CharSequence)this.lowCountLimit)) {
                worker.setHideLowCounts(Integer.parseInt(this.lowCountLimit));
            }
            if (!StringUtils.isEmpty((CharSequence)this.includeLabels)) {
                worker.setIncludeLabels(this.includeLabels);
            }
            if (!StringUtils.isEmpty((CharSequence)this.excludeLabels)) {
                worker.setExcludeLabels(this.excludeLabels);
            }
            String fileName = this.filePrefix + pluginTypes[i];
            if (this.exportMode == ExportMode.PNG) {
                fileName = fileName + ".png";
                worker.setOutputPNGFile(fileName);
                worker.addExportMode(1);
            } else {
                fileName = fileName + ".csv";
                worker.setOutputCSVFile(fileName);
                worker.addExportMode(2);
            }
            worker.setPluginType(pluginTypes[i]);
            int status = worker.doJob();
            if (status == 0) {
                log.info("Successful generation of file " + fileName + " by plugin:" + pluginTypes[i]);
                continue;
            }
            log.error("Error generating file " + fileName + " by plugin:" + pluginTypes[i]);
        }
    }

    private static boolean isTimeBasedGraph(String graphName) {
        return TIME_BASED_GRAPHS.contains(graphName);
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
    }

    public void add(SampleResult result) {
    }

    public void setProperty(JMeterProperty property) {
        String pn;
        if (property instanceof StringProperty && (pn = property.getName()).equals("exportMode")) {
            Object objectValue = property.getObjectValue();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
                ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                for (ExportMode e : ExportMode.values()) {
                    String propName = e.toString();
                    if (!objectValue.equals(rb.getObject(propName))) continue;
                    int tmpMode = e.ordinal();
                    if (log.isDebugEnabled()) {
                        log.debug("Converted " + pn + "=" + objectValue + " to mode=" + tmpMode + " using Locale: " + rb.getLocale());
                    }
                    super.setProperty(pn, tmpMode);
                    return;
                }
                log.warn("Could not convert " + pn + "=" + objectValue + " using Locale: " + rb.getLocale());
            }
            catch (IntrospectionException e) {
                log.error("Could not find BeanInfo", (Throwable)e);
            }
        }
        super.setProperty(property);
    }

    public boolean isStats() {
        return false;
    }

    public String getResultsFileName() {
        return this.resultsFileName;
    }

    public void setResultsFileName(String resultsFileName) {
        this.resultsFileName = resultsFileName;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public int getGraphWidth() {
        return this.graphWidth;
    }

    public void setGraphWidth(int graphWidth) {
        this.graphWidth = graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public void setGraphHeight(int graphHeight) {
        this.graphHeight = graphHeight;
    }

    public boolean isAggregateRows() {
        return this.aggregateRows;
    }

    public void setAggregateRows(boolean aggregateRows) {
        this.aggregateRows = aggregateRows;
    }

    public boolean isPaintZeroing() {
        return this.paintZeroing;
    }

    public void setPaintZeroing(boolean paintZeroing) {
        this.paintZeroing = paintZeroing;
    }

    public boolean isPaintGradient() {
        return this.paintGradient;
    }

    public void setPaintGradient(boolean paintGradient) {
        this.paintGradient = paintGradient;
    }

    public boolean isPreventOutliers() {
        return this.preventOutliers;
    }

    public void setPreventOutliers(boolean preventOutliers) {
        this.preventOutliers = preventOutliers;
    }

    public boolean isRelativeTimes() {
        return this.relativeTimes;
    }

    public void setRelativeTimes(boolean relativeTimes) {
        this.relativeTimes = relativeTimes;
    }

    public boolean isAutoScaleRows() {
        return this.autoScaleRows;
    }

    public void setAutoScaleRows(boolean autoScaleRows) {
        this.autoScaleRows = autoScaleRows;
    }

    public String getLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(String limitRows) {
        this.limitRows = limitRows;
    }

    public String getForceY() {
        return this.forceY;
    }

    public void setForceY(String forceY) {
        this.forceY = forceY;
    }

    public String getGranulation() {
        return this.granulation;
    }

    public void setGranulation(String granulation) {
        this.granulation = granulation;
    }

    public String getLineWeight() {
        return this.lineWeight;
    }

    public void setLineWeight(String lineWeight) {
        this.lineWeight = lineWeight;
    }

    public String getLowCountLimit() {
        return this.lowCountLimit;
    }

    public void setLowCountLimit(String lowCountLimit) {
        this.lowCountLimit = lowCountLimit;
    }

    public String getSuccessFilter() {
        return this.successFilter;
    }

    public void setSuccessFilter(String successFilter) {
        this.successFilter = successFilter;
    }

    public String getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(String includeLabels) {
        this.includeLabels = includeLabels;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(String excludeLabels) {
        this.excludeLabels = excludeLabels;
    }

    public int getExportMode() {
        return this.exportMode.ordinal();
    }

    public void setExportMode(int exportMode) {
        this.exportMode = ExportMode.values()[exportMode];
    }

    public String getPaintMarkers() {
        return this.paintMarkers;
    }

    public void setPaintMarkers(String paintMarkers) {
        this.paintMarkers = paintMarkers;
    }

    static {
        TIME_BASED_GRAPHS.add("ResponseTimesOverTime");
        TIME_BASED_GRAPHS.add("HitsPerSecond");
        TIME_BASED_GRAPHS.add("BytesThroughputOverTime");
        TIME_BASED_GRAPHS.add("LatenciesOverTime");
        TIME_BASED_GRAPHS.add("ResponseCodesPerSecond");
        TIME_BASED_GRAPHS.add("TransactionsPerSecond");
    }

    public static enum ExportMode {
        PNG(0),
        CSV(1);

        private byte value;

        private ExportMode(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

