/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.util.JMeterUtils;

public class FifoMap
extends ConcurrentHashMap<String, BlockingQueue<String>> {
    public static final String TIMEOUT_PROP = "kg.apc.jmeter.functions.FifoTimeout";
    public static final String CAPACITY_PROP = "kg.apc.jmeter.functions.FifoCapacity";
    private static FifoMap instance = new FifoMap();

    private FifoMap() {
    }

    public static FifoMap getInstance() {
        return instance;
    }

    private BlockingQueue<String> getFifo(String fifoName) {
        if (super.containsKey(fifoName)) {
            return (BlockingQueue)super.get(fifoName);
        }
        LinkedBlockingQueue<String> fifo = new LinkedBlockingQueue<String>(JMeterUtils.getPropDefault((String)TIMEOUT_PROP, (int)Integer.MAX_VALUE));
        super.put(fifoName, fifo);
        return fifo;
    }

    public String get(String fifoName) {
        BlockingQueue<String> fifo = this.getFifo(fifoName);
        String value = (String)fifo.peek();
        return value == null ? "" : value;
    }

    public String pop(String fifoName, long timeout) throws InterruptedException {
        BlockingQueue<String> fifo = this.getFifo(fifoName);
        String value = fifo.poll(timeout, TimeUnit.SECONDS);
        return value;
    }

    public int length(String fifoName) {
        BlockingQueue<String> fifo = this.getFifo(fifoName);
        int size = fifo.size();
        return size;
    }

    @Override
    public void put(String fifoName, String v) throws InterruptedException {
        this.getFifo(fifoName).offer(v, Long.MAX_VALUE, TimeUnit.SECONDS);
    }
}

