/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.BrowseAction;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.reporters.FlexibleFileWriter;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;

public class FlexibleFileWriterGui
extends AbstractListenerGui
implements ClipboardOwner {
    public static final String WIKIPAGE = "FlexibleFileWriter";
    private JTextField filename;
    private JTextField columns;
    private JCheckBox overwrite;
    private JTextArea header;
    private JTextArea footer;
    private JButton browseButton;
    private String[] fields = new String[]{"endTime", "Epoch time when the request was ended", "endTimeMillis", "Same as endTime, but divided by 1000 (surrogate field, eg. 1311122631.104)", "isFailed", "If response was marked as failed (surrogate field)", "isSuccsessful", "If response was marked as successful", "latency", "Latency, time to first response byte received (if available)", "latencyMicros", "Same as latency, but multiplied by 1000 (surrogate field)", "receivedBytes", "Number of request bytes received (if available)", "requestData", "Request data from sample", "responseCode", "Response code (eg. 200, 404, etc.)", "responseData", "Response data", "responseHeaders", "Response headers (if present in sample)", "responseMessage", "Response message (eg. OK, Not Found, etc.)", "responseTime", "Response time, time to full response loaded", "responseTimeMicros", "Same as responseTime, but multiplied by 1000 (surrogate field)", "sampleLabel", "Name of the sampler that made the request", "sentBytes", "Number of request bytes sent (if available)", "startTime", "Epoch time when the request was started", "startTimeMillis", "Same as startTime, but divided by 1000 (surrogate field, eg. 1311121131.062)", "threadName", "Name of thread in Thread Group that processed the request", "variable#<N>", "Sample variable with index N (eg. variable#2), see help for details"};

    public FlexibleFileWriterGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Flexible File Writer");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    public TestElement createTestElement() {
        FlexibleFileWriter te = new FlexibleFileWriter();
        this.modifyTestElement((TestElement)te);
        te.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return te;
    }

    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
        if (te instanceof FlexibleFileWriter) {
            FlexibleFileWriter fw = (FlexibleFileWriter)te;
            fw.setFilename(this.filename.getText());
            fw.setColumns(this.columns.getText());
            fw.setOverwrite(this.overwrite.isSelected());
            fw.setFileHeader(this.header.getText());
            fw.setFileFooter(this.footer.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void initFields() {
        this.filename.setText("testResults.txt");
        this.columns.setText("endTimeMillis|\\t|responseTime|\\t|latency|\\t|sentBytes|\\t|receivedBytes|\\t|isSuccessful|\\t|responseCode|\\r\\n");
        this.overwrite.setSelected(false);
        this.header.setText("endTimeMillis\tresponseTime\tlatency\tsentBytes\treceivedBytes\tisSuccessful\tresponseCode\n");
        this.footer.setText("");
    }

    public void configure(TestElement element) {
        super.configure(element);
        FlexibleFileWriter fw = (FlexibleFileWriter)element;
        this.filename.setText(fw.getFilename());
        this.columns.setText(fw.getColumns());
        this.overwrite.setSelected(fw.isOverwrite());
        this.header.setText(fw.getFileHeader());
        this.footer.setText(fw.getFileFooter());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Filename: ", 4));
        this.filename = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.filename);
        this.browseButton = new JButton("Browse...");
        this.addToPanel(mainPanel, labelConstraints, 2, 1, this.browseButton);
        GuiBuilderHelper.strechItemToComponent(this.filename, this.browseButton);
        this.browseButton.addActionListener(new BrowseAction(this.filename));
        this.addToPanel(mainPanel, labelConstraints, 0, 2, new JLabel("Overwrite existing file: ", 4));
        this.overwrite = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 2, this.overwrite);
        this.addToPanel(mainPanel, labelConstraints, 0, 3, new JLabel("Write File Header: ", 4));
        this.header = new JTextArea();
        this.header.setLineWrap(true);
        this.addToPanel(mainPanel, editConstraints, 1, 3, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.header, 3));
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 4, new JLabel("Record each sample as: ", 4));
        this.columns = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 4, this.columns);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 5, new JLabel("Write File Footer: ", 4));
        this.footer = new JTextArea();
        this.footer.setLineWrap(true);
        this.addToPanel(mainPanel, editConstraints, 1, 5, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.footer, 3));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
        this.add(this.createHelperPanel(), "South");
    }

    private JPanel createHelperPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(0, 0, 10, 0);
        labelConstraints.gridx = 0;
        labelConstraints.fill = 2;
        labelConstraints.gridwidth = 2;
        ret.add((Component)new JLabel("Available sample fields (click any button to copy the field to clipboard):"), labelConstraints);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.insets = new Insets(4, 0, 0, 0);
        buttonConstraints.gridx = 0;
        buttonConstraints.fill = 2;
        GridBagConstraints detailConstraints = new GridBagConstraints();
        detailConstraints.insets = new Insets(4, 10, 0, 0);
        detailConstraints.weightx = 1.0;
        detailConstraints.fill = 2;
        detailConstraints.gridx = 1;
        detailConstraints.anchor = 17;
        int line = 1;
        CopyAction copyAction = new CopyAction();
        for (int i = 0; i < this.fields.length / 2; ++i) {
            JButton fieldButton = new JButton(this.fields[2 * i]);
            fieldButton.addActionListener(copyAction);
            JTextField fieldDescription = new JTextField(this.fields[2 * i + 1]);
            fieldDescription.setEditable(false);
            fieldDescription.setBorder(null);
            fieldDescription.setOpaque(false);
            GuiBuilderHelper.strechItemToComponent(fieldDescription, fieldButton);
            buttonConstraints.gridy = line;
            detailConstraints.gridy = line++;
            ret.add((Component)fieldButton, buttonConstraints);
            ret.add((Component)fieldDescription, detailConstraints);
        }
        return ret;
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            Clipboard clipboard = FlexibleFileWriterGui.this.getToolkit().getSystemClipboard();
            Transferable transferable = new Transferable(){

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    if (this.isDataFlavorSupported(flavor)) {
                        return "|" + ((JButton)e.getSource()).getText() + "|";
                    }
                    return null;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.stringFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.stringFlavor.equals(flavor);
                }
            };
            clipboard.setContents(transferable, FlexibleFileWriterGui.this);
        }
    }
}

