/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kg.apc.jmeter.threads.AbstractSimpleThreadGroup;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UltimateThreadGroup
extends AbstractSimpleThreadGroup
implements Serializable,
TestListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DATA_PROPERTY = "ultimatethreadgroupdata";
    private PropertyIterator scheduleIT;
    private int threadsToSchedule;
    private CollectionProperty currentRecord;

    @Override
    protected void scheduleThread(JMeterThread thread, long tgStartTime) {
        log.debug("Scheduling thread: " + thread.getThreadName());
        if (this.threadsToSchedule < 1) {
            if (!this.scheduleIT.hasNext()) {
                throw new RuntimeException("Not enough schedule records for thread #" + thread.getThreadName());
            }
            this.currentRecord = (CollectionProperty)this.scheduleIT.next();
            this.threadsToSchedule = this.currentRecord.get(0).getIntValue();
        }
        int numThreads = this.currentRecord.get(0).getIntValue();
        int initialDelay = this.currentRecord.get(1).getIntValue();
        int startRampUp = this.currentRecord.get(2).getIntValue();
        int flightTime = this.currentRecord.get(3).getIntValue();
        int endRampUp = this.currentRecord.get(4).getIntValue();
        long ascentPoint = tgStartTime + (long)(1000 * initialDelay);
        int rampUpDelayForThread = (int)Math.floor((double)(1000 * startRampUp) * (double)this.threadsToSchedule / (double)numThreads);
        long startTime = ascentPoint + (long)rampUpDelayForThread;
        long descentPoint = startTime + (long)(1000 * flightTime) + (long)(1000 * startRampUp) - (long)rampUpDelayForThread;
        thread.setStartTime(startTime);
        thread.setEndTime(descentPoint + (long)((int)Math.floor((double)(1000 * endRampUp) * (double)this.threadsToSchedule / (double)numThreads)));
        thread.setScheduled(true);
        --this.threadsToSchedule;
    }

    public JMeterProperty getData() {
        return this.getProperty(DATA_PROPERTY);
    }

    void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public int getNumThreads() {
        int result = 0;
        JMeterProperty threadValues = this.getData();
        if (!(threadValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)threadValues;
            List rows = (List)columns.getObjectValue();
            for (Object row1 : rows) {
                CollectionProperty prop = (CollectionProperty)row1;
                ArrayList row = (ArrayList)prop.getObjectValue();
                result += ((JMeterProperty)row.get(0)).getIntValue();
            }
        }
        return result;
    }

    public void testStarted() {
        JMeterProperty data = this.getData();
        if (!(data instanceof NullProperty)) {
            this.scheduleIT = ((CollectionProperty)data).iterator();
        }
        this.threadsToSchedule = 0;
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testIterationStart(LoopIterationEvent event) {
    }
}

