/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kg.apc.charting.GraphPanelChart;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RateRenderer;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class AggregateReportGui
extends AbstractGraphPanelVisualizer {
    private Collection<String> emptyCollection = new ArrayList<String>();
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String USE_GROUP_NAME = "useGroupName";
    private static final String SAVE_HEADERS = "saveHeaders";
    private static final String[] COLUMNS = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_median", "aggregate_report_90%_line", "aggregate_report_min", "aggregate_report_max", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth", "aggregate_report_stddev"};
    private final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private final JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private final JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"), true);
    private final JCheckBox useGroupName = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_use_group_name"));
    private transient ObjectTableModel statModel;
    private final Map<String, SamplingStatCalculator> tableRows = new ConcurrentHashMap<String, SamplingStatCalculator>();
    private static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, null, null, null, null, null, null, new NumberRenderer("#0.00%"), new RateRenderer("#.0"), new NumberRenderer("#.0"), new NumberRenderer("#0.00")};

    public AggregateReportGui() {
        this.statModel = new ObjectTableModel(COLUMNS, SamplingStatCalculator.class, new Functor[]{new Functor("getLabel"), new Functor("getCount"), new Functor("getMeanAsNumber"), new Functor("getMedian"), new Functor("getPercentPoint", new Object[]{new Float(0.9)}), new Functor("getMin"), new Functor("getMax"), new Functor("getErrorPercentage"), new Functor("getRate"), new Functor("getKBPerSecond"), new Functor("getStandardDeviation")}, new Functor[]{null, null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, String.class, String.class, String.class, String.class});
        this.clearData();
        this.init();
    }

    public Collection<String> getMenuCategories() {
        return this.emptyCollection;
    }

    public String getLabelResource() {
        return "aggregate_report";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult res) {
        SamplingStatCalculator tot;
        SamplingStatCalculator row;
        if (!this.isSampleIncluded(res)) {
            return;
        }
        String sampleLabel = res.getSampleLabel(this.useGroupName.isSelected());
        SamplingStatCalculator samplingStatCalculator = this.tableRows;
        synchronized (samplingStatCalculator) {
            row = this.tableRows.get(sampleLabel);
            if (row == null) {
                row = new SamplingStatCalculator(sampleLabel);
                this.tableRows.put(row.getLabel(), row);
                this.statModel.insertRow((Object)row, this.statModel.getRowCount() - 1);
            }
        }
        samplingStatCalculator = row;
        synchronized (samplingStatCalculator) {
            row.addSample(res);
        }
        SamplingStatCalculator samplingStatCalculator2 = tot = this.tableRows.get(this.TOTAL_ROW_LABEL);
        synchronized (samplingStatCalculator2) {
            tot.addSample(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearData() {
        Map<String, SamplingStatCalculator> map = this.tableRows;
        synchronized (map) {
            this.statModel.clearData();
            this.tableRows.clear();
            this.tableRows.put(this.TOTAL_ROW_LABEL, new SamplingStatCalculator(this.TOTAL_ROW_LABEL));
            this.statModel.addRow((Object)this.tableRows.get(this.TOTAL_ROW_LABEL));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myJTable = new JTable((TableModel)this.statModel);
        this.myJTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])RENDERERS);
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
        JPanel opts = new JPanel();
        opts.add((Component)this.useGroupName, "West");
        opts.add((Component)this.saveTable, "Center");
        opts.add((Component)this.saveHeaders, "East");
        this.add(opts, "South");
    }

    @Override
    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(USE_GROUP_NAME, this.useGroupName.isSelected(), false);
        c.setProperty(SAVE_HEADERS, this.saveHeaders.isSelected(), true);
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        this.useGroupName.setSelected(el.getPropertyAsBoolean(USE_GROUP_NAME, false));
        this.saveHeaders.setSelected(el.getPropertyAsBoolean(SAVE_HEADERS, true));
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 0);
    }

    @Override
    public String getWikiPage() {
        return "JMeterPluginsCMD";
    }

    @Override
    public GraphPanelChart getGraphPanelChart() {
        return new FakeGraphPanelChart();
    }

    @Override
    public String getStaticLabel() {
        return "Nobody never should not see this. No, no, no.";
    }

    private class FakeGraphPanelChart
    extends GraphPanelChart {
        public FakeGraphPanelChart() {
            super(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveGraphToCSV(File file) throws IOException {
            log.info("Saving CSV to " + file.getAbsolutePath());
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                CSVSaveService.saveCSVStats((DefaultTableModel)AggregateReportGui.this.statModel, (FileWriter)writer, (boolean)AggregateReportGui.this.saveHeaders.isSelected());
            }
            catch (FileNotFoundException e) {
                log.warn(e.getMessage());
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", (Throwable)ex);
                }
            }
        }

        @Override
        public void saveGraphToPNG(File file, int w, int h) throws IOException {
            throw new UnsupportedOperationException("This plugin type cannot be saved as image");
        }
    }
}

