/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.util.HashSet;
import java.util.Iterator;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.vizualizers.CompositeModel;
import kg.apc.jmeter.vizualizers.CompositeResultCollector;
import kg.apc.jmeter.vizualizers.JCompositeRowsSelectorPanel;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class CompositeGraphGui
extends AbstractOverTimeVisualizer {
    private JCompositeRowsSelectorPanel compositeRowsSelectorPanel;
    public CompositeModel compositeModel;
    private long lastUpdate = 0L;
    private static String CONFIG_PROPERTY = "COMPOSITE_CFG";

    public CompositeGraphGui() {
        this.graphPanel.getGraphObject().setDisplayPrecision(false);
        this.compositeModel = new CompositeModel();
        this.compositeRowsSelectorPanel = new JCompositeRowsSelectorPanel(this.compositeModel, this);
        this.compositeModel.setNotifier(this.compositeRowsSelectorPanel);
        this.graphPanel.replaceRowTab("Graphs", this.compositeRowsSelectorPanel, "Select graphs/rows to display");
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        this.graphPanel.getGraphObject().setReSetColors(true);
        this.graphPanel.getGraphObject().setxAxisLabel("Elapsed time");
        this.graphPanel.getGraphObject().setYAxisLabel("Scaled values");
        this.graphPanel.getGraphObject().getChartSettings().setExpendRows(true);
        CompositeResultCollector compositeResultCollector = new CompositeResultCollector();
        compositeResultCollector.setCompositeModel(this.compositeModel);
        this.setModel(compositeResultCollector);
        this.hideFilePanel();
        this.enableMaximize(false);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 6938);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Composite Graph");
    }

    @Override
    public TestElement createTestElement() {
        ResultCollector modelNew = this.getModel();
        if (modelNew == null) {
            modelNew = new CompositeResultCollector();
            ((CompositeResultCollector)modelNew).setCompositeModel(this.compositeModel);
            this.setModel(modelNew);
        }
        this.modifyTestElement((TestElement)modelNew);
        modelNew.setComment(JMeterPluginsUtils.getWikiLinkText("CompositeGraph"));
        return modelNew;
    }

    @Override
    public void configure(TestElement te) {
        super.configure(te);
        ((CompositeResultCollector)te).setCompositeModel(this.compositeModel);
        JMeterProperty data = te.getProperty(CONFIG_PROPERTY);
        if (!(data instanceof NullProperty)) {
            this.setConfig((CollectionProperty)data);
        }
    }

    @Override
    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty((JMeterProperty)this.getConfig());
    }

    private CollectionProperty getConfig() {
        CollectionProperty ret = new CollectionProperty();
        CollectionProperty testplans = new CollectionProperty();
        CollectionProperty rows = new CollectionProperty();
        ret.setName(CONFIG_PROPERTY);
        Iterator<String[]> iter = this.compositeRowsSelectorPanel.getItems();
        while (iter.hasNext()) {
            String[] item = iter.next();
            testplans.addItem((Object)item[0]);
            rows.addItem((Object)item[1]);
        }
        ret.addItem((Object)testplans);
        ret.addItem((Object)rows);
        return ret;
    }

    private void setConfig(CollectionProperty properties) {
        PropertyIterator iter = properties.iterator();
        CollectionProperty testplans = (CollectionProperty)iter.next();
        CollectionProperty rows = (CollectionProperty)iter.next();
        if (rows.size() > 0) {
            PropertyIterator iterTestplans = testplans.iterator();
            PropertyIterator iterRows = rows.iterator();
            while (iterTestplans.hasNext() && iterRows.hasNext()) {
                String testplan = iterTestplans.next().getStringValue();
                String row = iterRows.next().getStringValue();
                this.compositeRowsSelectorPanel.addItemsToComposite(testplan, row);
            }
        }
    }

    @Override
    public void updateGui() {
        Iterator<String[]> iter = this.compositeRowsSelectorPanel.getItems();
        HashSet<String> validRows = new HashSet<String>();
        while (iter.hasNext()) {
            String[] item = iter.next();
            AbstractGraphRow row = this.compositeModel.getRow(item[0], item[1]);
            if (row == null) continue;
            String rowName = item[0] + " > " + item[1];
            validRows.add(rowName);
            if (this.model.containsKey(rowName)) continue;
            this.model.put(rowName, row);
            if (this.relativeStartTime != 0L && this.relativeStartTime <= row.getFirstTime()) continue;
            this.relativeStartTime = row.getFirstTime();
            this.handleRelativeStartTime();
        }
        Iterator iterModelRows = this.model.keySet().iterator();
        while (iterModelRows.hasNext()) {
            String rowName = (String)iterModelRows.next();
            if (validRows.contains(rowName)) continue;
            iterModelRows.remove();
        }
        super.updateGui();
    }

    @Override
    public void add(SampleResult sr) {
        super.add(sr);
        long time = System.currentTimeMillis();
        if (time > this.lastUpdate + 1000L) {
            this.lastUpdate = time;
            this.updateGui();
        }
    }

    @Override
    public String getWikiPage() {
        return "CompositeGraph";
    }

    @Override
    public void clearData() {
        super.clearData();
        this.updateGui();
    }
}

