/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CorrectedResultCollector
extends ResultCollector {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String INCLUDE_SAMPLE_LABELS = "include_sample_labels";
    public static final String EXCLUDE_SAMPLE_LABELS = "exclude_sample_labels";
    private static final String COMMA = ",";

    public void testStarted() {
        this.setupSaving();
        super.testStarted();
    }

    public void testStarted(String host) {
        this.setupSaving();
        super.testStarted(host);
    }

    private void setupSaving() {
        SampleSaveConfiguration conf = this.getSaveConfig();
        conf.setThreadCounts(true);
    }

    public List<String> getList(String prop) {
        String s = this.getPropertyAsString(prop);
        if (s.isEmpty()) {
            return new ArrayList<String>(0);
        }
        return Arrays.asList(s.split(COMMA));
    }

    public void setExcludeLabels(String excludeLabels) {
        this.setProperty(EXCLUDE_SAMPLE_LABELS, excludeLabels);
    }

    public void setIncludeLabels(String labels) {
        this.setProperty(INCLUDE_SAMPLE_LABELS, labels);
    }
}

